/***************************************************************************
 *                                                                         *
 *   LLIST.C                                                               *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the generic linked list library.                              *
 *                                                                         *
 *                                       - Mahesh Neelakanta 7/6/95        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gcspsrv.h"
#include "llist.h"

struct llist *
lladd(                             /* add/replace data to/in linked list   */
CHAR *key,                         /* the key to search on                 */
VOID *data,                        /* the generic data                     */
struct llist *list)                /* the list head                        */
{
     struct llist *tmp=list;

     while(tmp != NULL) {
          if (sameas(tmp->key,key)) {
               tmp->data=data;
               return(list);
          }
          tmp=tmp->next;
     }
     tmp=(struct llist *)alcmem(sizeof(struct llist));
     tmp->key=strdup(key);
     tmp->data=data;
     tmp->next=list;
     return(tmp);
}

VOID
lldel(                             /* delete an entry from the linked list */
CHAR *key,                         /* the key to search on                 */
struct llist *list)                /* the linked list head                 */
{
     struct llist *tmp=list;

     while(tmp != NULL) {
          if (sameas(tmp->key,key)) {
               free(tmp->key);
               list->next=tmp->next;
               free(tmp);
               break;
          }
          list=tmp;
          tmp=tmp->next;
     }
}

VOID *
llfind(                            /* find an entry in the linked list     */
CHAR *key,                         /* the key to search on                 */
struct llist *list)                /* the linked list head                 */
{
     while(list != NULL) {
          if (sameas(list->key,key)) {
               return(list->data);
          }
          list=list->next;
     }
     return(NULL);
}

VOID *
llfindclose(                       /* find an entry in the linked list     */
CHAR *key,                         /* the key to search on                 */
struct llist *list)                /* the linked list head                 */
{
     while(list != NULL) {
          if (samepato(list->key,key)) {
               return(list->data);
          }
          list=list->next;
     }
     return(NULL);
}

VOID
llfree(
struct llist *list)
{
     struct llist *tmp=list;

     while(tmp != NULL) {
          free(tmp->key);
          list=tmp->next;
          free(tmp);
          tmp=list;
     }
}
