/***************************************************************************
 *                                                                         *
 *   HELPSCN.C                                                             *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   Main console help (F1) screen module.                                 *
 *                                                                         *
 *                                              - Chris Robert 04/8/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"

#define FILREV "$Revision: 4 $"

UINT hlpkey(UINT scncod);

extern CHAR *chlpfn(VOID);

INT hlphdl;                   /* handle for the help screen                */

struct scrnid hlpscn={
     "wgssmhlp.bin",               /* screen filename                      */
     4000,
     0,                            /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     NULL,                         /* screen repaint routine               */
     hlpkey,                       /* key handler routine                  */
     NULL,                         /* occasional update routine            */
     0,                            /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     0,0,                          /* current cursor position on screen    */
     0,                            /* does cursor move?                    */
     0,                            /* should screen scroll?                */
     0,1,79,24,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

UINT
hlpkey(                            /* help screen key-hit handler routine  */
UINT scncod)                       /* keystoke hit by user                 */
{
     scngoaway(hlphdl);
     if (scncod != F1 && scncod != TAB && scncod != BAKTAB && scncod != ESC
         && (isascii(scncod) ? !isprint(scncod) : 1)) {
          keyhit(scncod);
     }
     return(0);
}
