/***************************************************************************
 *                                                                         *
 *   GALFDA.C                                                              *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the architecture independent conversion routines for int's,   *
 *   shorts, structs, etc.                                                 *
 *                                                                         *
 *                                       - Mahesh Neelakanta 6/12/95       *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "gcspsrv.h"
#include "llist.h"

extern CHAR *stppfx(CHAR *prefix); /* strip dynapak prefix of =???         */

static struct llist *aproot=NULL;  /* head of the appid's                  */

VOID
register_dpkfda(                   /* register a prefix+suffix/appid combo */
                                   /*  for conversion                      */
CHAR *appid,                       /*   the name of the app/agent          */
CHAR *key,                         /*   the dynapak's prefix+suffix        */
struct flddef *fda)                /*   field definition array for these   */
{
     struct llist *fxroot;

     if ((fxroot=(struct llist *)llfind(appid,aproot)) != NULL) {
          lladd(appid,fxroot=lladd(key,fda,fxroot),aproot);
     }
     else {
          fxroot=lladd(key,fda,NULL);
          aproot=lladd(appid,fxroot,aproot);
     }
}

struct flddef *                    /*   returns a ptr to the fda (or NULL) */
lookup_dpkfda(                     /* lookup a fda for the given dynapak   */
struct saunam *saunam)             /*   name of the dynapak (struct frm)   */
{
     struct llist *fxroot;
     CHAR *dpkstg;

     dpkstg=cnvs2d(saunam);
     if ((fxroot=(struct llist *)llfind(saunam->appid,aproot)) != NULL) {
          return((struct flddef *)llfindclose(dpkstg,fxroot));
     }
     return(NULL);
}
