/***************************************************************************
 *                                                                         *
 *   FTFZMOD.H                                                             *
 *                                                                         *
 *   Copyright (c) 1991-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   File Transfer Software header for ZMODEM                              *
 *                                                                         *
 *                                               - R. Stein  9/04/91       *
 *                                                                         *
 ***************************************************************************/

#ifndef __FTFZMOD_H
#define __FTFZMOD_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/*--- ZMODEM info ---*/
#define MAXHDR 31               /* Max number of bytes in a received header */
#define ZINSIZE 1024+5            /* Max size of input data block plus term */
#define ZATTNLEN 32                       /* Max length of attention string */

struct zmxdat {               /* data structure used during ZMODEM transmit */
     struct ftfscb scb;              /* standard session control block data */
     INT numhdr;                                     /* zmhchr() state code */
     CHAR hdrbuf[MAXHDR];                     /* buffer for received header */
     INT flags;                                     /* see masks, way below */
     INT pstate;                                       /* zmpchr() substate */
     INT hdrexp;                      /* characters expected in this header */

       /*** UNTIL THIS POINT struct zmxdat IS THE SAME AS struct zmrdat ***/
       /***  so that zmdinb(), etc., can handle both cases efficiently  ***/

     LONG txpos;                 /* total bytes transmitted (not nec ACK'd) */
     LONG confirm;    /* bytes xmitted before last feedback request (ZCRCQ) */
     ULONG filcrc;                       /* used to respond to ZCRC command */
};

#define zmxscb ((struct zmxdat *)ftfscb)
#define ZMXSIZ sizeof(struct zmxdat)

struct zmrdat {                /* data structure used during ZMODEM receive */
     struct ftfscb scb;              /* standard session control block data */
     INT numhdr;                                     /* zmhchr() state code */
     CHAR hdrbuf[MAXHDR];                     /* buffer for received header */
     INT flags;                                     /* see masks, way below */
     INT pstate;                                       /* zmpchr() substate */
     INT hdrexp;                      /* characters expected in this header */

       /*** UNTIL THIS POINT struct zmxdat IS THE SAME AS struct zmrdat ***/
       /***  so that zmdinb(), etc., can handle both cases efficiently  ***/

     CHAR packet[ZINSIZE];                         /* receiver input buffer */
     INT numpkt;               /* number of packet bytes stored in packet[] */
     CHAR attn[ZATTNLEN+1];                 /* attention string from ZSINIT */
     UINT fnucnt;                              /* files found for receiving */
     UINT uplcnt;                                /* files actually received */
     CHAR sopt0;                         /* [ZF0] options from ZFILE header */
     CHAR sopt1;                         /* [ZF1] options from ZFILE header */
     LONG mtime;         /* last time file was modified (secs since 1/1/70) */
     INT zadctr;                     /* count for automatic ZMODEM download */
};

#define zmrscb ((struct zmrdat *)ftfscb)
#define ZMRSIZ sizeof(struct zmrdat)

#if 0

numhdr - header receiver - byte count and state code
------
Possible values of zmrscb->numhdr / zmxscb->numhdr:

     -6   4 ZDLE's received in a row (1 more means cancel)
     -5   3 ZDLE's received in a row
     -4   2 ZDLE's received in a row
     -3   1 ZDLE's received out of the blue
     -2   waiting for a '*' pad character (THIS IS THE QUIESCENT STATE)
     -1   Got a '*', looking for a ZDLE
      0   Got '*' and ZDLE, looking for header identifier A/B/C
      1   Got A/B/C header format code, looking for rest of header
     2-n  Received the (possibly escape-coded) bytes of the header & stored
          them in hdrbuf[], including type, 4-byte data, CRC, etc.

pstate - packet receiver state code
------
Possible values of zmrscb->pstate / zmxscb->pstate:

     0    Not expecting packets
     1    Receiving packet data
    -1    Received a ZDLE escaping either a packet byte or the terminator
     2    Received & stored the packet terminator
    -2    Received a ZDLE escaping the 1st byte of the CRC
     3    Received the 1st byte of the CRC
    -3    Received a ZDLE escaping the 2nd byte of the CRC
     4    Received the 2nd byte of the CRC (we're done, if 16-bit CRC)
    -4    Received a ZDLE escaping the 3rd byte of the CRC
     5    Received the 3rd byte of the CRC
    -5    Received a ZDLE escaping the 4th byte of the CRC
     6    Received the 4th byte of the CRC (done, if 32-byte CRC)

(Note:  pstate is always 0 during ZMODEM file transmit)

#endif                             /* if 0                                 */

/*--- Masks for zmxdat/zmrdat flags ---*/

#define ZDBLK1  0x0001                   /* transmiting first block of file */
#define ZRESUMA 0x0002       /* rcv/transmit all files with resume flag set */
#define ZRESUM1 0x0004      /* rcv/transmit first file with resume flag set */
#define ZXOFF   0x0008                             /* Zmodem XOFF throttled */
#define ZCTLESC 0x0010                 /* Zmodem control characters escaped */
#define ZCRC32  0x0020               /* Zmodem receiver can handle CRC-32's */
#define ZGOTH32 0x0040     /* Last valid A or C type header rcvd was type C */
#define ZNAMED  0x0080    /* receive 1 named file (versus use sender names) */
#define ZUTIME  0x0100     /* time to start timing transfer (w/next packet) */

INT
ftfzad(                              /* check for automatic ZMODEM download */
CHAR c);                   /* pass all interactive incoming characters here */
                           /* Call ftpzmr.start() entry point to begin with */
                               /* then call ftfzad() on all incoming chars. */
                              /* Note, it won't hurt to call ftpzmr.start() */
                                          /* at any time between transfers, */
                                 /* even if a ZMODEM transfer never starts. */
                                /* Returns 1 when download should be begun. */
                                       /* Global inputs: ftfpsp and ftfscb. */

extern struct ftfpsp ftpzmr;                            /* ZMODEM receiving */
extern struct ftfpsp ftpzmx;                         /* ZMODEM transmitting */
extern struct ftfpsp ftpzrx;    /* ZMODEM transmitting w/attempted RESUMING */

#define ZBOVHEAD (2+2*4)      /* max possible overhead in ZMODEM sub-packet */
   /* (2-ch terminator, plus 4-byte CRC, each byte of which can be escaped) */

                      /* The actual size of a ZMODEM sub-packet might be as */
                   /* high as (2*1024+ZBOVHEAD)=2058 bytes due to escaping. */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __FTFZMOD_H                          */
