/***************************************************************************
 *                                                                         *
 *   FTFXYMD.H                                                             *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Transfer Software header for XMODEM and YMODEM                   *
 *                                                                         *
 *                                                  - R. Stein  1/92       *
 *                                                                         *
 ***************************************************************************/

#ifndef __FTFXYMD_H
#define __FTFXYMD_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

struct xymdat {     /* data fields used for XMODEM/YMODEM receive/transmit */
     struct ftfscb scb;            /* standard session control block data  */
     CHAR flags;                   /* X/YMODEM recv/xmit flags, see below  */
     CHAR blknum;                  /* expected block number 0-255          */
     INT retry;                    /* count consecutive retries            */
     CHAR headc;                   /*  \                                   */
     CHAR gotbkn;                  /*   \                                  */
     CHAR notbkn;                  /*    > X/YMODEM packet buffer          */
     CHAR block[1024];             /*   /                                  */
     USHORT crc;                   /*  /                                   */
     INT nbytes;                   /* # of actual data bytes in this packet*/
     CHAR nak;                     /* NAK or 'G' or 'C'                    */
     INT toxtra;                   /* opt extra timeout value (in ticks)   */
};

#define xymscb ((struct xymdat *)ftfscb)


/* X/YMODEM receive/transmit flags */
#define XUF1024  0x02              /* accept/use 1024-byte blocks?         */
#define XUFCRC   0x04              /* expect/use 2-byte crc?(vs 1-by csum) */
#define XUTIME   0x08              /* when to start timing                 */
#define XUBATCH  0x10              /* batch capability                     */
#define XUNAMNX  0x20              /* fname coming in next block for rec   */
#define XUFG     0x40              /* "G" option for YMODEM Batch          */
#define XXLOCK   0x80              /* transmission locked (XOFF)           */

extern struct ftfpsp ftpxmr;       /* XMODEM-Checksum receiving            */
extern struct ftfpsp ftpxmx;       /* XMODEM-Checksum transmitting         */
extern struct ftfpsp ftpxcr;       /* XMODEM-CRC receiving                 */
extern struct ftfpsp ftpxcx;       /* XMODEM-CRC transmitting              */
extern struct ftfpsp ftpx1r;       /* XMODEM-1K receiving                  */
extern struct ftfpsp ftpx1x;       /* XMODEM-1K transmitting               */
extern struct ftfpsp ftpybr;       /* YMODEM Batch receiving               */
extern struct ftfpsp ftpybx;       /* YMODEM Batch transmitting            */
extern struct ftfpsp ftpygr;       /* YMODEM-g receiving                   */
extern struct ftfpsp ftpygx;       /* YMODEM-g transmitting                */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __FTFXYMD_H                          */
