/***************************************************************************
 *                                                                         *
 *   FTFVIEW.H                                                             *
 *                                                                         *
 *   Copyright (C) 1992-1997 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   File Transfer Software ZIP/ARC/ZOO/LZH/ICE/PSE/ZSE file viewer        *
 *                                                                         *
 *   With all operating-system-specific functions removed (I/O, disk,      *
 *   memory, time), the pure file transfer algorithm can be isolated,      *
 *                                                                         *
 *                 - Bob Stein (glue) and Rob Rose (technology)  1/21/92   *
 *                                                                         *
 ***************************************************************************/

#ifndef __FTFVIEW_H
#define __FTFVIEW_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

struct vewdat {                    /* data fields used for View transmit   */
     struct ftfscb scb;            /* standard session control block data  */
     CHAR filid;                   /* archive file id's, see below         */
     LONG pos;
};

#define vewscb ((struct vewdat *)ftfscb)

                                   /* Archive file id's, ret'd by zafilid()*/
#define UNKFILE 0                  /*   Unknown file format                */
#define ARCFILE 1                  /*   ARC                                */
#define ZIPFILE 2                  /*   ZIP                                */
#define ICEFILE 3                  /*   ICE or LZH                         */
#define ZOOFILE 4                  /*   ZOO                                */
#define ZSEFILE 5                  /*   Zip Self-Extracting                */
#define PSEFILE 6                  /*   Pak Self-Extracting                */
#define ZP2FILE 7                  /*   ZIP V2                             */
#define ZS2FILE 8                  /*   ZIP V2 Self-Extracting             */

#define NUMVFILE 9                 /* number of viewable file types        */

extern CHAR *arcdsc[];             /* Array of file desc indexed by file id*/

#define VIDCHUNK 52    /* View file ID, chunk of file necessary to identify */

INT
zafilid(                           /* Identify File type                   */
CHAR *recbuf);                     /* first VIDCHUNK bytes of file         */
                                   /* returns file id                      */
extern struct ftfpsp ftpvew;       /* ARC/ZIP/etc file View transmitting   */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __FTFVIEW_H                          */
