/***************************************************************************
 *                                                                         *
 *   ELOGAPI.H                                                             *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Functions for adding events into the Event Log (NT only)              *
 *                                                                         *
 *                                                - I. Minkin 5/22/96      *
 *                                                                         *
 ***************************************************************************/

#ifndef __ELOGAPI_H
#define __ELOGAPI_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define SEV_MASK     0xC0000000    // error severity bit mask

VOID
elogSetServName(                   // set current source for events
const CHAR *pServName);            //   source name

VOID
elogSetServDispName(               // set cur service name to display in ELog
const CHAR *pServDispName);        //   service display name

VOID
elogAPIError(                      // log an API error into the Event Log
const CHAR *pMsg);                 //   additional message to log

VOID
elogStatus(                        // log status into the Event Log
ULONG status,                      //   status to log
const CHAR **pInsertStg,           //   insert strings
INT numInserts);                   //   number of insert strings

VOID
elogStatusEx(                      // log status into the Event Log
ULONG status,                      //   status to log
const CHAR **pInsertStg,           //   insert strings
INT numInserts,                    //   number of insert strings
const CHAR *pSourceName);          //   source name

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __ELOGAPI_H
