/***************************************************************************
 *                                                                         *
 *   DFTSTATS.C                                                            *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.      All Rights Reserved.   *
 *                                                                         *
 *   This is the suite of default statistic screen handlers.               *
 *                                                                         *
 *                                             - Chris Robert 03/01/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"
#include "statscns.h"

#define FILREV "$Revision: 4 $"

static UINT kysta8(UINT scncod);
static UINT kysta9(UINT scncod);
static struct clstab *gnxcls(struct clstab *from);
static VOID upsta7(VOID),upsta8(VOID),upsta9(VOID),dspmds(VOID);

static INT pnum=0;                 /* page number for classes stat screen  */
static INT mpno=0;                 /* page number for modules stat screen  */

struct statsc graph1={             /* statistic screen interface structure */
     "Lines-in-use",               /*   name of statistic screen           */
     "wgssta1.bin",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph2={             /* statistic screen interface structure */
     "Calls/baud",                 /*   name of statistic screen           */
     "wgssta2.bin",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph3={             /* statistic screen interface structure */
     "Time used/hr",               /*   name of statistic screen           */
     "wgssta3.bin",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph4={             /* statistic screen interface structure */
     "Time used/g#",               /*   name of statistic screen           */
     "wgssta4.bin",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph5={             /* statistic screen interface structure */
     "Crds used/hr",               /*   name of statistic screen           */
     "wgssta5.bin",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph6={             /* statistic screen interface structure */
     "Crds used/g#",               /*   name of statistic screen           */
     "wgssta6.bin",                /*   file name to get screen from       */
     NULL,                         /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     NULL,                         /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph7={             /* statistic screen interface structure */
     "Demographics",               /*   name of statistic screen           */
     "wgssta7.bin",                /*   file name to get screen from       */
     upsta7,                       /*   initialize (bring up scn) routine  */
     NULL,                         /*   key hit handler routine            */
     upsta7,                       /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph8={             /* statistic screen interface structure */
     "Class stats",                /*   name of statistic screen           */
     "wgssta8.bin",                /*   file name to get screen from       */
     upsta8,                       /*   initialize (bring up scn) routine  */
     kysta8,                       /*   key hit handler routine            */
     upsta8,                       /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

struct statsc graph9={             /* statistic screen interface structure */
     "Misc. stats",                /*   name of statistic screen           */
     "wgssta9.bin",                /*   file name to get screen from       */
     upsta9,                       /*   initialize (bring up scn) routine  */
     kysta9,                       /*   key hit handler routine            */
     upsta9,                       /*   occasional update (every 60 secs)  */
     NULL,                         /*   once-per-cycle routine             */
     NULL                          /*   take down screen routine           */
};

VOID
inidst(VOID)                       /* initialize default stat screens      */
{
     register_stascn(&graph1);
     register_stascn(&graph2);
     register_stascn(&graph3);
     register_stascn(&graph4);
     register_stascn(&graph5);
     register_stascn(&graph6);
     register_stascn(&graph7);
     register_stascn(&graph8);
     register_stascn(&graph9);
}

static
VOID
upsta7(VOID)                       /* fill in the demographics screen      */
{
     INT ct,ab;
     static UINT cttot;
     static UINT agetot[NAGEBK];

     for (ab=0 ; ab < NAGEBK ; ab++) {
          agetot[ab]=0;
     }
     for (ct=1 ; ct < NACMTY ; ct++) {
          setatr((ct&1) ? 0x1F : 0x1E);
          for (ab=0,cttot=0 ; ab < NAGEBK ; ab++) {
               printfat(31+(ab*6),5+ct,"%5u",sv2.matrix[ct][ab]);
               cttot+=sv2.matrix[ct][ab];
               agetot[ab]+=sv2.matrix[ct][ab];
          }
          printfat(61,5+ct,"%5u",cttot);
     }
     setatr(0x1E);
     for (ab=0,cttot=0 ; ab < NAGEBK ; ab++) {
          printfat(31+(ab*6),9,"%5u",sv2.matrix[0][ab]);
          cttot+=sv2.matrix[0][ab];
          agetot[ab]+=sv2.matrix[0][ab];
     }
     printfat(61,9,"%5u",cttot);
     setatr(0x1F);
     for (ab=0 ; ab < NAGEBK ; ab++) {
          printfat(31+(ab*6),11,"%5u",agetot[ab]);
     }
     printfat(61,11,"%5.5s",l2as(sv2.numact));
     printfat(26,15,"%5.5s",l2as(sv2.numact-sv2.numfem));
     printfat(37,15,"%5.5s",l2as(sv2.numfem));
     printfat(48,15,"%5.5s",l2as(sv2.numcor));
     printfat(59,15,"%5.5s",l2as(sv2.numans));
}

static
VOID
upsta8(VOID)                       /* fill in the classes stat screen      */
{
     INT i;
     LONG val;

     if ((clsptr=clshead) == NULL) {
          return;
     }
     if (clsptr->flags&HASCRD && clsptr->flags&NOCRED) {
          clsptr=gnxcls(clsptr);
     }
     for (i=1 ; i <= 14*pnum ; i++) {
          clsptr=gnxcls(clsptr);
     }
     for (i=0 ; i < 14 ; i++) {
          if (clsptr == NULL) {
               setatr(0x1F);
               printfat(17,3+i,"%16.16s","");
               setatr(0x1E);
               printfat(34,3+i,"%7.7s","");
               printfat(42,3+i,"%7.7s","");
               printfat(50,3+i,"%7.7s","");
               printfat(58,3+i,"%11.11s","");
          }
          else {
               setatr(0x1F);
               printfat(17,3+i,"%-16.16s",clsptr->clname);
               setatr(0x1E);
               val=(clsptr->seconds+1800L)/3600L;
               printfat(34,3+i,"%7.7s",l2as(val));
               val=(((clsptr->seconds+1800L)/3600L)*24+dtrack/2)/dtrack;
               printfat(42,3+i,"%7.7s",l2as(val));
               printfat(50,3+i,"%7u",clsptr->users);
               val=((clsptr->seconds)*24+dtrack/2)/dtrack;
               val=(val/(clsptr->users > 0 ? clsptr->users : 1)+30L)/60L;
               printfat(58,3+i,"%11.11s",l2as(val));
          }
          clsptr=gnxcls(clsptr);
     }
     if (numcls > 14) {
          setatr(0x1A);
          printfat(18,17,"");
          printfat(31,17,"");
          setatr(0x1E);
          if (pnum == 0) {
               printfat(19,17," PgDn(more) ");
          }
          else if (numcls > (pnum+1)*14) {
               printfat(19,17,"PgDn or PgUp");
          }
          else {
               printfat(19,17," PgUp(more) ");
          }
     }
}

static
struct clstab *
gnxcls(from)                       /* get the next class in sequence       */
struct clstab *from;                    /* starting from here              */
{
     struct clstab *ptr=from;

     while (ptr != NULL) {
          ptr=ptr->next;
          if (ptr == NULL || !(ptr->flags&HASCRD && ptr->flags&NOCRED)) {
               break;
          }
     }
     return(ptr);
}

static
VOID
upsta9(VOID)                       /* fill in the misc. stats screen       */
{
     setatr(0x1E);
     printfat(61,3,"%8.8s",spr("%ld",sv2.totcalls));
     printfat(61,4,"%8.8s",spr("%ld",sv.uplds));
     printfat(61,5,"%8.8s",spr("%ld",sv.dwnlds));
     printfat(61,6,"%8.8s",spr("%ld",sv.msgtot));
     printfat(61,9,"%8u",sv.emlopn);
     printfat(61,10,"%8u",sv.sigopn);
     printfat(61,12,"%8.8s",spr("%ld",sv2.x25mbs));
     printfat(61,13,"%8.8s",spr("%ld",sv2.x25kps));
     printfat(59,15,"%10.10s",spr("%lu",(ULONG)sv2.freepst));
     printfat(59,16,"%10.10s",spr("%lu",(ULONG)sv2.paidpst));
     dspmds();
}

static
VOID
dspmds(VOID)                       /* display module stats on screen       */
{
     INT i,id;

     for (i=0,id=mpno*14 ; i < 14 ; i++,id++) {
          if (id < nmods) {
               setatr(0x1F);
               printfat(16,3+i,"%-17.17s",mdstats[id].mdname);
               setatr(0x1E);
               printfat(34,3+i,"%7.7s",
               l2as((mdstats[id].seconds+1800L)/3600L));
               printfat(42,3+i,"%9.9s",l2as(mdstats[id].creds));
          }
          else {
               setatr(0x1F);
               printfat(16,3+i,"%-17.17s","");
               setatr(0x1E);
               printfat(34,3+i,"%7.7s","");
               printfat(42,3+i,"%9.9s","");
          }
     }
     if (nmods > 14) {
          setatr(0x1A);
          printfat(17,17,"");
          printfat(31,17,"");
          setatr(0x1E);
          if (mpno == 0) {
               printfat(18,17,"PgDn for more");
          }
          else if (nmods > (mpno+1)*14) {
               printfat(18,17,"  PgDn/PgUp  ");
          }
          else {
               printfat(18,17,"PgUp for more");
          }
     }
}

static UINT
kysta8(                            /* default stats screen #8 key handler  */
UINT scncod)                            /* scan code for key pressed       */
{
     switch (scncod) {
     case PGDN:
          if (numcls > (pnum+1)*14) {
               pnum++;
               upsta8();
          }
          break;
     case PGUP:
          if (pnum != 0) {
               pnum--;
               upsta8();
          }
          break;
     default:
          return(scncod);
     }
     return(0);
}

static UINT
kysta9(                            /* default stats screen #9 key handler  */
UINT scncod)                            /* scan code for key pressed       */
{
     switch (scncod) {
     case PGDN:
          if (nmods > (mpno+1)*14) {
               mpno++;
               dspmds();
          }
          break;
     case PGUP:
          if (mpno != 0) {
               mpno--;
               dspmds();
          }
          break;
     default:
          return(scncod);
     }
     return(0);
}
