/***************************************************************************
 *                                                                         *
 *   CALLINIT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Loads all modules and calls init__xxx() function for each of them     *
 *                                                                         *
 *                                    - Ilya Minkin    1/29/96             *
 *                                                                         *
 ***************************************************************************/
#include <windows.h>
#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 8 $"

extern INT shdl;
extern INT stthue;
INT curdlls=0;                /* # of dlls currently loaded                */

static VOID loadModule(CHAR *moduleName,GBOOL dieFlag);

VOID
callinits(VOID)          /* set up from WGSERV.CFG file (including DLLs)   */
{
     FILE *fp;
     CHAR buf[512],*pBuf;

     if ((fp=fopen("wgserv.cfg",FOPRB)) == NULL) {
          catastro("Can't find DLL list (wgserv.cfg)!");
     }
     while (fgets(buf,sizeof(buf),fp) != NULL) {
          pBuf=skpwht(unpad(buf));
          if (sameto("DLL=",pBuf)) {
               pBuf=skpwht(&pBuf[4]);
               actvscn(shdl);
               setatr(stthue);
               printfat(32,20,"Loading: %8.8s               ",pBuf);
               loadModule(pBuf,TRUE);
          }
     }
     fclose(fp);
     actvscn(shdl);
     setatr(stthue);
     printfat(28,20,"                                     ");
}

VOID
loadModule(                        /* load module & call all init functions*/
CHAR *moduleName,                  /*   module name                        */
GBOOL dieFlag)                     /*   catastro if error                  */
{
     CHAR buf[GCMAXPTH];
     CHAR msgbuf[256];
     HINSTANCE hInst;
     FARPROC initFunc;
     typedef VOID (*INITFUNC)(VOID);

     stlcpy(buf,moduleName,sizeof(buf));
     stlcat(buf,".DLL",sizeof(buf));
     if ((hInst=LoadLibrary(buf)) != NULL) {
          curdlls++;
#ifdef WEBCAST
          stlcpy(buf,"_initwc__",sizeof(buf));
#else
          stlcpy(buf,"_init__",sizeof(buf));
#endif
          stlcat(buf,moduleName,sizeof(buf));
          strlwr(buf);
          if ((initFunc=GetProcAddress(hInst,buf)) != NULL){
               ((INITFUNC)initFunc)();
          }
     }
     else if (dieFlag) {
          catastro("LOADDLL: Unable to load module %s! %s",
                   buf,getLastErrorText(msgbuf,sizeof(msgbuf)));
     }
}
