/***************************************************************************
 *                                                                         *
 *   BBSUTILS.C                                                            *
 *                                                                         *
 *   Copyright (c) 1990-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is General Purpose BBS functions.                                *
 *                                                                         *
 *                                            - R. Skurnick   12/5/89      *
 *                                            - S. Brinker                 *
 *                                            - A. Von Gauss               *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "bbsutils.h"

#define FILREV "$Revision: 4 $"

static INT addrdn(INT max);
static LONG addlng(LONG max);
static INT fndnum(INT base);

INT mtretv,                        /* CNC last return value                */
    mtrint;                        /* CNC returned integer                 */
UINT mtruni;                       /* CNC returned unsigned integer        */
LONG mtrlng;                       /* CNC returned long integer            */
CHAR mtrbuf[MTRBUF_SIZ];           /* CNC string buffer                    */


VOID
dspmsg(                            /* Display Message based on ANSI flag   */
INT msgno,
CHAR *parm1,
CHAR *parm2,
CHAR *parm3)
{
     prfmsg((usaptr->ansifl&ANSON) ? msgno+1 : msgno,parm1,parm2,parm3);
}

VOID
dspmlt(                            /* Display Message based on ANSI flag   */
INT msgno,
CHAR *parm1,
CHAR *parm2,
CHAR *parm3)
{
     prfmlt((usaptr->ansifl&ANSON) ? msgno+1 : msgno,parm1,parm2,parm3);
}

INT
genrdn(min,max)               /* Create a random number between min/max-1  */
INT min,max;
{
     INT rnum;

     if (!max) {
          return(0);
     }
     ASSERT(min <= max);
     if (min >= max) {
          return(min);
     }
     rnum=rand()%max;
     while (rnum < min) {
          rnum+=(addrdn(max-rnum));
     }
     return(rnum);
}

static INT
addrdn(max)                   /* Add random number to current random       */
INT max;
{
     return(rand()%max);
}

LONG
lngrnd(min,max)               /* Generate a long random number             */
LONG min,max;
{
     LONG rnum;

     if (!max) {
          return(0L);
     }
     ASSERT(min <= max);
     if (min >= max) {
          return(min);
     }
     rnum=rand()%max;
     while (rnum < min) {
          rnum+=(addlng(max-rnum));
     }
     return(rnum);
}

static LONG
addlng(max)                   /* Add long random number                    */
LONG max;
{
     return(rand()%max);
}

INT
mtgstg(mulwrd,maxlen)         /* Get character string using CNC            */
INT mulwrd,maxlen;
{
     INT idx;
     CHAR *r;

     setmem(mtrbuf,MTRBUF_SIZ,0);
     if (mulwrd) {
          strncpy(mtrbuf,cncall(),maxlen-1);
          mtretv=strlen(mtrbuf);
     }
     else {
          for (r=mtrbuf,idx=0 ; isprint(*nxtcmd) && (idx < maxlen-1)
                                  ; nxtcmd++,r++,idx++) {
               *r=((idx == 0) ? toupper(*nxtcmd) : tolower(*nxtcmd));
          }
     }
     while (*nxtcmd > ' ') {
          nxtcmd++;
     }
     if (sameas(mtrbuf,"X")) {
          mtretv=-1;
     }
     else if (sameas(mtrbuf,"?")) {
          mtretv=-2;
     }
     else {
          mtretv=strlen(mtrbuf);
     }
     return(mtretv);
}

INT
mtgchn(min,max)               /* Get channel number using CNC              */
INT min,max;
{
     if (mtghex(min,max) == 1) {
          if (usridx(mtrint) == -1) {
               mtretv=-3;
          }
     }
     return(mtretv);
}

INT
mtgbas(base,min,max)          /* Get long integer using CNC (w/ base)      */
INT base;
LONG min,max;
{
     INT tmpnum,minus=0;

     while (*nxtcmd == '-') {
          minus=1;
          nxtcmd++;
     }
     mtrlng=0L;
     if ((tmpnum=fndnum(base)) >= 0) {
          do {
               mtrlng=((mtrlng*(LONG)base)+tmpnum);
          } while ((tmpnum=fndnum(base)) >= 0);
          mtruni=(UINT)mtrlng;
          if (minus) {
               mtrlng=0L-mtrlng;
          }
          mtrint=(INT)mtrlng;
          if (mtrlng < min) {
               cncall();
               mtretv=-3;
          }
          else if (mtrlng > max) {
               cncall();
               mtretv=-4;
          }
          else {
               mtretv=1;
          }
     }
     else {
          switch (toupper(*nxtcmd)) {
          case 'X':
               cncchr();
               mtretv=-1;
               break;
          case '?':
               cncchr();
               mtretv=-2;
               break;
          default:
               mtretv=0;
          }
     }
     return(mtretv);
}

static INT
fndnum(base)                  /* Check to see if <nxtcmd> is <base>        */
INT base;
{
     INT i;
     static CHAR intarr[16]={'0','1','2','3','4','5','6','7',
                             '8','9','A','B','C','D','E','F'};

     for (i=0 ; i < base ; i++) {
          if (toupper(*nxtcmd) == intarr[i]) {
               nxtcmd++;
               return(i);
          }
     }
     return(-1);
}



