/***************************************************************************
 *                                                                         *
 *   BADUID.C                                                              *
 *                                                                         *
 *   Copyright (c) 1997      Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Returns bad User-IDs based on a text file                             *
 *                                                                         *
 *                                        - D. Pitchford 2/4/97            *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 3 $"

#define BUFILE "WGSBADID.TXT"

static VOID cklist(VOID);
static VOID dllist(VOID);

static struct badu {               // linked list of bad User-IDs
     CHAR uid[UIDSIZ];             //   a bad userid
     struct badu *next;            //   the next one
} *buhead=NULL;                    // head record

GBOOL                              //   returns TRUE if not in list
isgooduid(                         // check User-ID passed
CHAR *uid)                         //   User-ID to check
{
     struct badu *b;

     cklist();
     for (b=buhead ; b != NULL ; b=b->next) {
          if (sameas(uid,b->uid)) {
               return(FALSE);
          }
     }
     return(TRUE);
}

static VOID
cklist(VOID)                       // checks & loads bad User-ID list
{
     static GBOOL ever=FALSE;
     static struct ffblk fs;
     struct ffblk fb;
     struct badu *b;
     INT tfresult;

     if (fndfile(&fb,BUFILE,0)) {
          if (!ever
           || fb.ff_fdate != fs.ff_fdate
           || fb.ff_ftime != fs.ff_ftime
           || fb.ff_fsize != fs.ff_fsize) {
               if (tfsopn(BUFILE) == 1) {
                    ever=TRUE;
                    fs=fb;
                    dllist();
                    while ((tfresult=tfsrdl()) != TFSDUN) {
                         if (tfresult == TFSLIN && tfsbuf[0] != '\0') {
                              b=(struct badu *)alczer(sizeof(struct badu));
                              stlcpy(b->uid,tfsbuf,UIDSIZ);
                              b->next=buhead;
                              buhead=b;
                         }
                    }
               }
               else {
                    ever=FALSE;
               }
          }
     }
     else {
          dllist();
     }
}

static VOID
dllist(VOID)                       // delete User-ID list
{
     struct badu *b;

     while (buhead != NULL) {
          b=buhead;
          buhead=buhead->next;
          free(b);
     }
}
