/***************************************************************************
 *                                                                         *
 *   ABOUT.C                                                               *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.       All Rights Reserved.  *
 *                                                                         *
 *   About screen code                                                     *
 *                                                                         *
 *                                            - Robert A. Rose 02/12/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "oprlow.h"

#define FILREV "$Revision: 9 $"

UINT abokey(UINT scncod);
VOID aborep(VOID);
CHAR *osversn(VOID);

extern INT usshdl;                 /* handle for the users screen          */
INT ahdl=0;                        /* handle for the about screen          */
extern INT acchdl;                 /* handle for the account screen        */

extern INT maxdlls;                /* maximum # of DLLs to be loaded       */

struct scrnid abouscn={
     "wgsabt.bin",                 /* screen filename                      */
     3040,                         /* length of screen (4000 for full scrn)*/
     ALT_B,                        /* select scan code (from main screen)  */
                                   /* ala 'Keyboard Accelerator'           */
     NULL,                         /* screen going away routine            */
     aborep,                       /* screen repaint routine               */
     abokey,                       /* key handler routine                  */
     aborep,                       /* occasional update routine            */
     180,                          /* seconds between occasional updates   */
     0,                            /* seconds to go before next update     */
     NULL,                         /* called every cycle when displayed    */
     2,0,                          /* current cursor position on screen    */
     0,                            /* does cursor move?                    */
     1,                            /* should screen scroll?                */
     1,1,70,17,                    /* scrolling for window (default)       */
     NULL,                         /* perm. save buffer                    */
     NULL                          /* current location of screen           */
};

UINT
abokey(                       /* Monitor screen keystroke handler routine  */
UINT scncod)                       /* keystoke hit                         */
{
     switch (scncod) {
     case TAB:
          scn2mai(acchdl);
          break;
     case BAKTAB:
          scn2mai(usshdl);
          break;
     default:
          return(scncod);
     }
     return(0);
}

CHAR *
osversn(VOID)           /* return operating system version info      */
{
     CHAR tmpstr[15];

     *vdatmp='\0';
     stlcpy(vdatmp,itoa(_osmajor,tmpstr,10),15);
     strcat(vdatmp,".");
     stlcat(vdatmp,itoa(_osminor,tmpstr,10),15);
     return(vdatmp);
}

VOID
aborep(VOID)                       /* About screen repaint routine         */
{
     actvscn(ahdl);
     setatr(0x1E);
     printfat(14,4,"%.9s",bturno);                    /* common screen code */
     printfat(14,5,"%s%s",version,subvers);
     printfat(14,6,"%d",nterms);
#ifdef GCWINNT
     printfat(48,4,"(See System Registry)");
#else
     if (btrset[0] != '\0') {
          printfat(48,4,"%-20s",btrset);
     }
     else {
          printfat(48,4,"(defaults)");
     }
#endif // GCWINNT
     printfat(48,5,"%-7.7s",dbytes(dskfre(".")));
     printfat(48,6,"%d",curdlls);
     aboutos();
}
