/***************************************************************************
 *                                                                         *
 *   WELOGDAT.H                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   WG Event Log data and monitor to access shared memory mapped file.    *
 *                                                                         *
 *                                        - I. Minkin 9/10/96              *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>

class _export welogData
{
public:
     welogData(const CHAR *_eventSource,
               const CHAR *_eventText,
               const SYSTEMTIME *eventTime=NULL);
     VOID formatString(CHAR *pBuf,INT bufSize);
     welogData();

private:
     SYSTEMTIME eventTime;
     CHAR eventSource[32];
     CHAR eventText[512];
};

class _export welogDataMon
{
public:
     welogDataMon();
     ~welogDataMon();
     bool put(welogData& value,DWORD timeOut);
     bool get(welogData& value,DWORD timeOut);

private:
     HANDLE hevBufFull;
     HANDLE hevBufEmpty;
     HANDLE hmBufBusy;
     HANDLE hfData;
     SECURITY_DESCRIPTOR *pSD;
};
