/***************************************************************************
 *                                                                         *
 *   WELOGDAT.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   WG Event Log data and monitor to access shared memory mapped file.    *
 *                                                                         *
 *                                        - I. Minkin 9/10/96              *
 *                                                                         *
 ***************************************************************************/

#include "welogdat.h"

#define FILREV "$Revision: 4 $"

welogData::welogData() // HACK
{
     memset(this,0,sizeof(this));
}

welogData::welogData(const CHAR *_eventSource,const CHAR *_eventText,const SYSTEMTIME *_eventTime)
{
     lstrcpyn(eventText,_eventText,sizeof(eventText));
     for (INT len=lstrlen(eventText),i=0 ; i < len ; i++) {
          if (eventText[i] < ' ' || eventText[i] > '~') {
               eventText[i]=' ';
          }
     }
     INT len=lstrlen(_eventSource);
     if (len < sizeof(eventSource)) {
          lstrcpy(eventSource,_eventSource);
     }
     else {
          lstrcpy(eventSource,"...");
          lstrcat(eventSource,&_eventSource[len-sizeof(eventSource)+4]);
     }
     if (_eventTime) {
          eventTime=*_eventTime;
     }
     else {
          GetLocalTime(&eventTime);
     }
}

VOID welogData::formatString(CHAR *pBuf,INT bufSize)
{
     CHAR tmpBuf[sizeof(eventSource)+sizeof(eventText)+128];
     GetDateFormat(LOCALE_SYSTEM_DEFAULT,0,&eventTime,NULL,tmpBuf,sizeof(tmpBuf));
     INT len=lstrlen(tmpBuf);
     tmpBuf[len++]='\t';
     GetTimeFormat(LOCALE_SYSTEM_DEFAULT,0,&eventTime,NULL,&tmpBuf[len],sizeof(tmpBuf)-len);
     lstrcat(tmpBuf,"\t");
     lstrcat(tmpBuf,eventSource);
     lstrcat(tmpBuf," - ");
     lstrcat(tmpBuf,eventText);
     lstrcpyn(pBuf,tmpBuf,bufSize);
}

////////////////////////////////////////////////////////////////////////////////

welogDataMon::welogDataMon()
{
     SECURITY_ATTRIBUTES sa;
     sa.nLength=sizeof(SECURITY_ATTRIBUTES);
     sa.bInheritHandle=FALSE;

     pSD=(SECURITY_DESCRIPTOR*)LocalAlloc(LPTR,SECURITY_DESCRIPTOR_MIN_LENGTH);
     if (pSD
      && InitializeSecurityDescriptor(pSD,SECURITY_DESCRIPTOR_REVISION)
      && SetSecurityDescriptorDacl(pSD,TRUE,(PACL)NULL,FALSE)) {
         sa.lpSecurityDescriptor=pSD;
     }
     else {
          sa.lpSecurityDescriptor=NULL;
     }
     hevBufFull=CreateEvent(&sa,TRUE,FALSE,"/EVENT/WGSERVER/WELOGBUFFULL");
     hevBufEmpty=CreateEvent(&sa,TRUE,TRUE,"/EVENT/WGSERVER/WELOGBUFEMPTY");
     hmBufBusy=CreateMutex(&sa,FALSE,"/MUTEX/WGSERVER/WELOGBUFBUSY");
     hfData=CreateFileMapping((HANDLE)0xFFFFFFFF,&sa,PAGE_READWRITE,0,
                              512,"/FILE/WGSERVER/WELOGDATA");
}

welogDataMon::~welogDataMon()
{
     CloseHandle(hevBufFull);
     CloseHandle(hevBufEmpty);
     CloseHandle(hmBufBusy);
     CloseHandle(hfData);
     if (pSD) {
          LocalFree(pSD);
     }
}

bool welogDataMon::get(welogData& value,DWORD timeOut)
{
     HANDLE hWait[2]={hmBufBusy,hevBufFull};
     bool retVal=FALSE;

     DWORD waitResult=WaitForMultipleObjects(2,hWait,TRUE,timeOut);
     if (waitResult != WAIT_FAILED && waitResult != WAIT_TIMEOUT) {
          welogData *data=static_cast<welogData *>(MapViewOfFile(hfData,FILE_MAP_READ,0,0,512));
          if (data != NULL) {
               value=*data;
               UnmapViewOfFile(data);
               ResetEvent(hevBufFull);
               SetEvent(hevBufEmpty);
               retVal=TRUE;
          }
          ReleaseMutex(hmBufBusy);
     }
     return(retVal);
}

bool welogDataMon::put(welogData& value,DWORD timeOut)
{
     HANDLE hWait[2]={hmBufBusy,hevBufEmpty};
     bool retVal=FALSE;

     DWORD waitResult=WaitForMultipleObjects(2,hWait,TRUE,timeOut);
     if (waitResult != WAIT_FAILED && waitResult != WAIT_TIMEOUT) {
          welogData *data=static_cast<welogData *>(MapViewOfFile(hfData,FILE_MAP_WRITE,0,0,512));
          if (data != NULL) {
               *data=value;
               UnmapViewOfFile(data);
               ResetEvent(hevBufEmpty);
               SetEvent(hevBufFull);
               retVal=TRUE;
          }
          ReleaseMutex(hmBufBusy);
     }
     return(retVal);
}
