/***************************************************************************
 *                                                                         *
 *   WELOGCLI.CPP                                                          *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   WG Event Log client.                                                  *
 *                                                                         *
 *                                        - I. Minkin 9/10/96              *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "welog.h"
#include "welogdat.h"

#define FILREV "$Revision: 3 $"

static VOID welogRunServer();

welogDataMon mon;                  // monitor to access shared mem mapped file

VOID WINAPI _export
welogAdd(                          // add to WG event log
const CHAR *data)                  //   data to add
{
     CHAR exeName[1024];

     welogRunServer();
     if (!GetModuleFileName(NULL,exeName,sizeof(exeName))) {
          exeName[0]='\0';
     }
     welogData wd(exeName,data);
     mon.put(wd,1000);
}

static VOID
welogRunServer()                   // runs WG event log server
{
     HANDLE hevELogRunning=OpenEvent(EVENT_ALL_ACCESS,FALSE,"/EVENT/WGSERVER/WELOGRUNNING");
     if (hevELogRunning == NULL) {
          STARTUPINFO startInfo;
          PROCESS_INFORMATION procInfo;
          memset(&startInfo,0,sizeof(STARTUPINFO));
          startInfo.cb=sizeof(STARTUPINFO);
          startInfo.lpDesktop="WinSta0\\Default";
          if (!CreateProcess(NULL,                // programm name
                             (LPTSTR)"wgswelog.exe", // command line string
                             NULL,                // process security attributes
                             NULL,                // thread security attributes
                             FALSE,               // handle inheritance flag
                             CREATE_DEFAULT_ERROR_MODE, // creation flags
                             NULL,                // new environment block
                             NULL,                // current directory name
                             &startInfo,          // STARTUPINFO
                             &procInfo)) {        // PROCESS_INFORMATION
               return;
          }
          for (INT i=0 ; i < 10 && hevELogRunning == NULL ; i++) {
               Sleep(2000);
               hevELogRunning=OpenEvent(EVENT_ALL_ACCESS,FALSE,"/EVENT/WGSERVER/WELOGRUNNING");
          }
     }
     if (hevELogRunning != NULL) {
          WaitForSingleObject(hevELogRunning,5000);
          CloseHandle(hevELogRunning);
     }
}
