/***************************************************************************
 *                                                                         *
 *   WGSSTART.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.     All Rights Reserved.    *
 *                                                                         *
 *   This program performs necessary tasks upon initial installation or    *
 *   upgrade of Worldgroup.                                                *
 *                                                                         *
 *                                        - D. Pitchford   08/29/96        *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "excphand.h"
#include "runapp.h"

#define FILREV "$Revision: 6 $"

INT WINAPI
WinMain(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     CHAR *pTmp;
     CHAR path[2048];
     INT retVal;
     INT mbRes;

     (VOID)hPrevInstance;
     (VOID)lpCmdLine;
     (VOID)nCmdShow;
     GetModuleFileName(hInstance,path,sizeof(path));
     if ((pTmp=strrchr(path,'\\')) != NULL
          || (pTmp=strrchr(path,'/')) != NULL) {
          *pTmp='\0';
          chdir(path);
          *pTmp='\\';
     }
     rename("wgsclean.new","wgsclean.mdf");
     unlink("wgsclean.new");
     if (!runApp("wgsswzd",NULL,SW_SHOWDEFAULT,&retVal)) {
          MessageBox(NULL,"Unable to execute the Setup Wizard!",path,
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
     }
     mbRes = MessageBox( NULL,
                         "If you like, Installation can now run the Worldgroup "
                         "Manager Packaging Utility.  This utility will be used "
                         "to create the distributable client software.\r\r"
                         "If you choose not to create the client software now, "
                         "you must run the Packaging Utility later to allow users to "
#ifdef WEBCAST
                         "broadcast video.\r\r"
#else
                         "access your server.\r\r"
#endif
                         "Would you like to create the distributable client software now?",
                         "Important Information",
                         MB_YESNO|MB_TASKMODAL|MB_SETFOREGROUND|MB_ICONQUESTION);

     if (mbRes == IDYES) {
          if (!runApp("wgsmkwgm",NULL,SW_SHOWDEFAULT,&retVal)) {
               MessageBox(NULL,"Unable to run the Worldgroup Manager "
                         "Packacging Utility!",path,
                         MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          }
     }
EXCEPT
     return(0);
}

