/***************************************************************************
 *                                                                         *
 *   WGSRUNMT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Offline utility to handle WGSMTREE under NT.                          *
 *                                                                         *
 *                                        - Richard Skurnick 05/31/96      *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "excphand.h"
#include "runapp.h"

#define FILREV "$Revision: 14 $"

INT WINAPI
WinMain(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     CHAR *pTmp;
     CHAR path[2048],cline[2048];
     INT retVal;

     (VOID)hPrevInstance;
     (VOID)nCmdShow;
     GetModuleFileName(hInstance,path,sizeof(path));
     if (!canRunGroup()) {
          MessageBox(NULL,NOPROCEED,
                    path,MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
     if ((pTmp=strrchr(path,'\\')) != NULL
          || (pTmp=strrchr(path,'/')) != NULL) {
          *pTmp='\0';
          chdir(path);
          *pTmp='\\';
     }
     if (!runApp("wgsint",NULL,SW_SHOWDEFAULT,&retVal)) {
          MessageBox(NULL,"Unable to execute WGSINT!",path,
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
     if (retVal == 200) {
          return(1);
     }
     AllocConsole();
     stlcpy(cline,"wgsmtree.exe -wgsrunmt",sizeof(cline));
     if (*lpCmdLine != '\0') {
          stlcat(cline," ",sizeof(cline));
          stlcat(cline,lpCmdLine,sizeof(cline));
     }
     if (!runApp(cline,"Menu Tree Editor",SW_SHOWDEFAULT,&retVal)) {
          MessageBox(NULL,"Unable to execute WGSMTREE!",path,
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          FreeConsole();
          return(1);
     }
     if (retVal == 1) {
          MessageBox(NULL,"An error occured while running WGSMTREE!",path,
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          FreeConsole();
          return(1);
     }
     FreeConsole();
     return(0);
EXCEPT
     return(1);
}
