/***************************************************************************
 *                                                                         *
 *   WGSRUNCD.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Offline utility to handle WGSDFCVT under NT/95.                       *
 *                                                                         *
 *                                        - Richard Skurnick 07/01/96      *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "excphand.h"
#include "runapp.h"

#define FILREV "$Revision: 5 $"

INT WINAPI
WinMain(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     CHAR *pTmp;
     CHAR path[2048];
     INT retVal;

     (VOID)hPrevInstance;
     (VOID)lpCmdLine;
     (VOID)nCmdShow;
     GetModuleFileName(hInstance,path,sizeof(path));
     if (!canRunGroup()) {
          MessageBox(NULL,NOPROCEED,
                    path,MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
     if ((pTmp=strrchr(path,'\\')) != NULL
          || (pTmp=strrchr(path,'/')) != NULL) {
          *pTmp='\0';
          chdir(path);
          *pTmp='\\';
     }
     AllocConsole();
     if (!runApp("wgsdfcvt",NULL,SW_SHOWDEFAULT,&retVal)) {
          MessageBox(NULL,"Unable to execute WGSDFCVT!",path,
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          FreeConsole();
          return(1);
     }
     if (retVal >= 70) {
          MessageBox(NULL,"An error occured while running WGSDFCVT!",path,
                     MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          FreeConsole();
          return(1);
     }
     runApp("cnfdn.bat 1",NULL,SW_SHOWDEFAULT,&retVal);
     FreeConsole();
     return(0);
EXCEPT
     return(1);
}
