/***************************************************************************
 *                                                                         *
 *   THREADU.H                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is a suite of utility routines for dealing with Forum message    *
 *   threads.                                                              *
 *                                                                         *
 *                                               - C. Robert  10/25/94     *
 *                                                                         *
 ***************************************************************************/

#ifndef __THREADU_H
#define __THREADU_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

VOID
inithu(                            /* initialize thread utilities          */
INT maxinm);                       /*   max # of threads in in-memory cache*/

USHORT
ninthr(                            /* get number of messages in a thread   */
USHORT forum,                      /*   forum number thread resides in     */
LONG thrid);                       /*   unique thread ID within Forum      */

GBOOL                              /*   did this just create a new thread? */
incthr(                            /* increment # of messages in a thread  */
USHORT forum,                      /*   forum number thread resides in     */
LONG thrid);                       /*   unique thread ID within Forum      */

GBOOL                              /*   did this just destroy a thread?    */
decthr(                            /* decrement # of messages in a thread  */
USHORT forum,                      /*   forum number thread resides in     */
LONG thrid);                       /*   unique thread ID within Forum      */

VOID
setthrc(                           /* set number of messages in thread     */
USHORT forum,                      /*   forum ID thread is in              */
LONG thrid,                        /*   thread ID of thread                */
USHORT msgcnt);                    /*   number of messages in thread       */

VOID
cathrs(VOID);                      /* clear all thread counters (mcu only) */

VOID
cfthrs(                            /* clr Forum thread counters (mcu only) */
USHORT forum);                     /*   Forum to clear all threads for     */

VOID
clsthu(VOID);                      /* close down thread utilities          */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __THREADU_H                          */
