/***************************************************************************
 *                                                                         *
 *   BBSGEN.C                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Manages mainline 'Main Executive' records in the generic user         *
 *   database bbsgen.dat.                                                  *
 *                                                                         *
 *                                      -R. Stein 2/9/93                   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 5 $"

struct bbsgen genbuf;    /* for reading Main Exec records from bbsgen.dat  */
static INT ggrc;         /* global used between getgen() and setgen()      */

INT
getgen(genbuf,userid)              /* read bbsgen.dat's Main Executive info*/
struct bbsgen *genbuf;             /* where to put (or format) stuff       */
CHAR *userid;
{                                  /* returns 1=read 0=new, formatted      */
     setmem(genbuf,sizeof(struct bbsgen),0);
     strcpy(genbuf->userid,userid);
     strcpy(genbuf->modnam,BBSGMX);
     dfaSetBlk(genbb);
     if ((ggrc=dfaAcqEQ(genbuf,genbuf,0)) != 0) {
          if (dfaLastLen() > sizeof(struct bbsgen)) {
               catastro("%s record too large for Main Executive\n"
                    "(did you downgrade your version??)", fnmcse("wgsgen.dat"));
          }
     }
     dfaRstBlk();
     return(ggrc);
}

VOID
setgen(genbuf)                     /* write Main Exec record to bbsgen.dat */
struct bbsgen *genbuf;             /* record, could be from getgen()       */
{
     dfaSetBlk(genbb);
     if (ggrc) {
          dfaUpdateV(genbuf,sizeof(struct bbsgen));
     }
     else {
          dfaInsertV(genbuf,sizeof(struct bbsgen));
     }
     dfaRstBlk();
}
