/***************************************************************************
 *                                                                         *
 *   WGSMUP.C                                                              *
 *                                                                         *
 *   Copyright (c) 1989-1997 Galacticomm, Inc.  All Rights Reserved        *
 *                                                                         *
 *   This program moves .DAT files not in the destination directory        *
 *   to it, from the source directory.  It does the same for .MSG files    *
 *   too, but also "merges" .MSG's present in both directories, so that    *
 *   the resulting destination directory files have the structure and      *
 *   message order of the original source directory files, but the         *
 *   message-contents of the original destination directory files.  The    *
 *   original destination directory .MSG files are renamed to another      *
 *   filetype in the process (if files of this type are already present    *
 *   when WGSMUP is invoked, they are used in place of the .MSG's).        *
 *                                                                         *
 *   If a language name is passed on the command-line, WGSMUP will copy    *
 *   text blocks for any one language from the new MSG file to the output  *
 *   one.  Passing "English/RIP" as the language parameter will cause all  *
 *   English/RIP text blocks in the new MSG file to go into the output     *
 *   one, ignoring any changes the Sysop may have made to existing         *
 *   messages.  Do not pass a language name to treat all languages in the  *
 *   default manner.                                                       *
 *                                                                         *
 *   If the keyword "END_UPD" is found immediately before a LEVEL## {}     *
 *   directive, WGSMUP will copy the remaining contents of the *old*       *
 *   message file into the output file.                                    *
 *                                                                         *
 *   The destination directory is always the current default directory.    *
 *                                                                         *
 *   Usage:                                                                *
 *                                                                         *
 *        WGSMUP <source dir> <file(s)-can be *> <filetype to apply>       *
 *                                                                         *
 *                                            - T. Stryker 2/7/89          *
 *                                              (walhf SJB)                *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "updutl.h"
#include "excphand.h"

#define FILREV "$Revision: 7 $"

extern CHAR scntbl[][GVIDSCNSIZ];/* linked in screens (c/o MAKESCNS)*/

CHAR *scnptr;                      /* pointer to "saved" screen buffer     */

INT dosx,dosy;                     /* saved DOS cursor position (for exit) */

CHAR oldn[80],                     /* old message file name                */
     newn[80],                     /* new message file name                */
     outn[80];                     /* output message file name             */

struct msgent {                    /* message file linked-list entry       */
     struct msgent *link;          /*   forward ptr                        */
     CHAR name[13];                /*   file name including .msg & '\0'    */
} mshead,*mstptr=&mshead;          /* linked-list pointers for msg files   */

VOID fillist(struct ffblk *fb);
VOID opnwnd(VOID);
VOID clswnd(VOID);

INT
main(argc,argv)                    /* main program loop                    */
INT argc;                          /* number of command-line args          */
CHAR *argv[];                      /* array of command-line args           */
{
TRY
     struct ffblk fb;
     struct msgent *numsg;
     CHAR owlang[LNGSIZ],fptmp[GCMAXFNM];

#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#endif // GCWINNT
     initvid();
     nlingo=MAXLANG;
     if (argc < 4) {
          printf("WGSMUP -- Message Update/Merge Utility\n");
          printf("Copyright (c) 1989-1997 GALACTICOMM, Inc.  All Rights "
                 "Reserved.\n");
          printf("\n Command format is:\n");
          printf(" WGSMUP <new path> <file name> <extension for old file> "
                 "<import-all lang>\n");
          gcdelay(5*1000);
          clsvid();
          return(1);
     }
     if (argc > 4) {
          stzcpy(owlang,argv[4],LNGSIZ);
     }
     else {
          owlang[0]='\0';
     }
     sprintf(newn,"%s%s.msg",argv[1],argv[2]);
     if (fnd1st(&fb,newn,0)) {
          opnwnd();
          fillist(&fb);
          for (numsg=mshead.link ; numsg != NULL ; numsg=numsg->link) {
               sprintf(newn,"%s%s",argv[1],numsg->name);
               sprintf(outn,"%s",numsg->name);
               fnmcse(newn);
               fnmcse(outn);
               if (!fnd1st(&fb,outn,0)) {
                    printf("\n Moving %s to default server directory",newn);
                    rename(newn,outn);
               }
               else {
                    sprintf(oldn,"%s.%s",
                            fileparts(GCPART_FILE,numsg->name,fptmp,GCMAXFNM),
                            argv[3]);
                    fnmcse(oldn);
                    printf("\n Merging %s into %s",newn,outn);
                    merge1(oldn,newn,outn,owlang);
               }
          }
          clswnd();
     }
     else {
          printf("WGSMUP: No match for \"%s\" found!\n",newn);
     }
     sprintf(newn,"%s*.dat",argv[1]);
     if (fnd1st(&fb,newn,0)) {
          opnwnd();
          fillist(&fb);
          for (numsg=mshead.link ; numsg != NULL ; numsg=numsg->link) {
               sprintf(newn,"%s%s",argv[1],numsg->name);
               sprintf(outn,"%s",numsg->name);
               if (!fnd1st(&fb,outn,0)) {
                    fnmcse(newn);
                    printf("\n Moving %s to default server directory",newn);
                    rename(newn,outn);
               }
          }
          clswnd();
     }
     clsvid();
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}

VOID
fillist(fb)                        /* gen in-memory linked list of files   */
struct ffblk *fb;                 /* fb to use (returned from fnd1st)     */
{
     struct msgent *numsg;

     mshead.link=NULL;
     mstptr=&mshead;
     do {
          numsg=(struct msgent *)alcmem(sizeof(struct msgent));
          numsg->link=NULL;
          strcpy(numsg->name,fb->ff_name);
          mstptr->link=numsg;
          mstptr=numsg;
     } while (fndnxt(fb));
}

VOID
opnwnd(VOID)                       /* open up the WGSMUP work window       */
{
     dosx=curcurx();
     dosy=curcury();
     scn2mem(scnptr=alcmem(GVIDSCNSIZ),0,GVIDSCNSIZ);
     explodeto(cvtscn(scntbl[0]),0,0,75,10,1,7);
     proff(0,0);
     setwin(NULL,2,10,69,16,1);
     setatr(0x1F);
     locate(2,9);
     cursiz(GVIDNOCURS);
}

VOID
clswnd(VOID)                       /* close up the WGSMUP work window      */
{
     mem2scn(scnptr,0,GVIDSCNSIZ);
     setwin(NULL,0,0,79,24,1);
     free(scnptr);
     locate(dosx,dosy);
     cursiz(GVIDLILCURS);
     setatr(0x07);
}
