/***************************************************************************
 *                                                                         *
 *   EDTOFF.H                                                              *
 *                                                                         *
 *   Copyright (c) 1993-1997 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   Offline editor registration and centralized handling routines, as     *
 *   used by CNF and Menu Tree (header).                                   *
 *                                                                         *
 *                                               - R. Stein  1/21/93       *
 *                                                                         *
 ***************************************************************************/

#ifndef __EDTOFF_H
#define __EDTOFF_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

/*--- editor handler routine return codes ---*/
#define EONOTME -1             /* I'm not the editor specified in "command" */
#define EOERROR 0   /* some kind of error occurred (see about edterr below) */
#define EOABORT 1             /* operator aborted editing, recover old data */
#define EONOCHG 2                                      /* no change to data */
#define EOTRUNC 3                            /* data truncated (ref ibsize) */
#define EOSAVE  4                           /* Done editing, save this data */
#define EOWHICH 0x07                         /* mask for above return codes */
#define EOPGUP  0x80     /* in add'n to SAVE or NOCHG, skip to option above */
#define EOPGDN  0x40     /* in add'n to SAVE or NOCHG, skip to option below */
                /* (when EONOCHG/EOTRUNC/EOSAVE is unknown, EOSAVE is used) */

extern INT nedts;                  /* number of editor routines            */
extern LONG ibsize;                /* bytes read in by impbuf()            */
                                   /* set whenever anyone returns EOTRUNC */
extern INT edtskp;                 /* 1=allow PgUp or PgDn to end edit session*/
extern INT edtkey;                 /* if edtskp and the retval is >= EONOCHG, */
                                   /* then this can be the aborting character */
extern CHAR EXPORT edterr[];       /* editor error message                 */

#if 0

The <edterr> error message is displayed by CNF like this:

                This CNF Editor command <edterr>:
                "<editor command with %s expanded>"

So some appropriate strings for <edterr> would be:

               cannot create "CNF00000.RIP" for editing
               requires more real-mode memory
               erased the SAVE.TXT file
               failed

That is, the message should be a complete sentence but with the subject
missing, it should not be capitalized, and it should not have a period.

#endif                             /* if 0                                 */

typedef INT EDTHANDLER(                           /* Editor Handler routine */
     CHAR *command,                  /* editor command line (per .MDF file) */
     CHAR *txtbuf,        /* in-place editing buffer (NULL=already on disk) */
     UINT sizbuf);               /* size of buffer in bytes (includes '\0') */

extern EDTHANDLER **edthandlers;/* array of ptrs to editor handler routines */

VOID
regedtoff(                                    /* register an offline editor */
EDTHANDLER *edthdl);    /* ptr to editor handler (see EOXXXXX return codes) */

VOID
eospawn(VOID);  /* register DLL, spawn(.exe), and system() editors handlers */
  /* be sure to call eospawn() after all other editors have been registered */

INT
edtoff(                                                  /* edit this stuff */
CHAR *command,                       /* editor command line (per .MDF file) */
CHAR *txtbuf,             /* in-place editing buffer (NULL=already on disk) */
UINT sizbuf,                     /* size of buffer in bytes (includes '\0') */
CHAR *tfn);                                 /* name to use for file, if any */
               /* see EOXXXXX return codes (EONOTME means no handler found) */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __EDTOFF_H                           */
