/***************************************************************************
 *                                                                         *
 *   ANYCHG.C                                                              *
 *                                                                         *
 *   Copyright (c) 1987-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the integration-checker that WGSINT.EXE and WGSINTRO.EXE use  *
 *   to determine if system files need regeneration.  If there has been    *
 *   any change in time, date, or size on any of the .MDF files in the     *
 *   current directory, or any re-arrangement of them, or any change in    *
 *   the time, date, or size of WGSMENU2.DAT since the last time it ran,   *
 *   anychg() returns 1, otherwise 0.                                      *
 *                                                                         *
 *                                            - T. Stryker 2/17/92         *
 *                                            - R. Stein   2/2/93          *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 10 $"

GBOOL anychg(GBOOL patreq);
GBOOL mjrup(VOID);

GBOOL                              /* returns TRUE if there has been a change*/
anychg(
GBOOL patreq)
{                             /*    *.mdf or wgsmenu2.dat since it last ran*/
     FILE *fp;
     struct ffblk dirfb,oldfb;

     (void)patreq;
     if ((fp=fopen("wgsint.run",FOPRB)) != NULL) {
          fclose(fp);
          unlink("wgsint.run");
          return(1);
     }
     if (isfile("GALNSSF\\*.*")) {
          return(1);
     }
     if ((fp=fopen("wgsint.ref",FOPRB)) == NULL) {
          return(1);
     }
#ifdef GCDOS
     if (fndfile(&oldfb,"wgsbtr.bat",0)) {
          if ((oldfb.ff_attrib&FAMRON) == 0) {
               if (fndfile(&dirfb,"wgsbreq.ini",0)) {
                    if (oldfb.ff_fdate < dirfb.ff_fdate
               || (dirfb.ff_fdate == oldfb.ff_fdate
                && oldfb.ff_ftime < dirfb.ff_ftime)) {
                         fclose(fp);
                         return(1);
                    }
               }
          }
     }
     else {
          fclose(fp);
          return(1);
     }
#endif // GCDOS
     if (fnd1st(&dirfb,"*.mdf",0)) {
          do {
               if (fread(&oldfb,sizeof(struct ffblk),1,fp) != 1
                || !sameas(oldfb.ff_name,dirfb.ff_name)
                || oldfb.ff_ftime != dirfb.ff_ftime
                || oldfb.ff_fdate != dirfb.ff_fdate
                || oldfb.ff_fsize != dirfb.ff_fsize) {
                    fclose(fp);
                    return(1);
               }
          } while (fndnxt(&dirfb));
     }
     if (!fndfile(&dirfb,"wgsmenu2.dat",0)
      || fread(&oldfb,sizeof(struct ffblk),1,fp) != 1
      || oldfb.ff_ftime != dirfb.ff_ftime
      || oldfb.ff_fdate != dirfb.ff_fdate
      || oldfb.ff_fsize != dirfb.ff_fsize) {
          fclose(fp);
          return(1);
     }
     if (!isfile("wgsuser.doc")) {
        fclose(fp);
        return(1);
     }
     fclose(fp);
     return(0);
}
