/***************************************************************************
 *                                                                         *
 *   WGSINCCF.C                                                            *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.  All rights reserved.       *
 *                                                                         *
 *   This utility will include new client applications into the client     *
 *   packaging utility.  This will do all of the necessary compression     *
 *   required by InstallSHIELD.                                            *
 *                                                                         *
 *                                                - C. Dunn 1/4/95         *
 *                                                                         *
 ***************************************************************************/

#ifdef GCWINNT
#include <windows.h>
#endif
#include "gcomm.h"
#include "majorbbs.h"
#include "process.h"
#include "excphand.h"

#define FILREV "$Revision: 6 $"

#define EXITOK 0                   /* exit code for successful compress    */
#define PRGNAM "WGSISCOM.EXE"      /* compress program file name           */
#define INCDIR "WGMINST\\INCLUDE"  /* include subdirectory name            */
#define NOARG  ""                  /* no argument string for spawnl()      */

CHAR *cnv2is(CHAR *filnam);

INT
main(                              /* main program loop                    */
INT argc,                          /*   number of command line arguments   */
CHAR *argv[])                      /*   array of command line arguments    */
{
TRY
     CHAR *incfil;
     CHAR tmppath[GCMAXPTH];
#ifdef GCDOS
     INT retcod;
#else
     STARTUPINFO si;
     PROCESS_INFORMATION pi;
     CHAR cmdbuf[260];
     DWORD procrc;
#endif // GCDOS

#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#endif // GCWINNT
     initvid();
     printf("\n");
     setatr(0x0A);
     printf("WGSINCCF - Galacticomm Client App Include Utility\n");
     printf("Copyright (c) 1995-1997 Galacticomm, Inc.  All rights reserved.\n\n");
     if (argc != 3) {
          setatr(0x0D);
          belper(800);
          printf("\7     Usage: WGSINCCF <path and file name> <app id>\n");
          printf("     Example: WGSINCCF GALFIL\\GALFL100.EXE GALFIL\n");
          setatr(0x07);
          printf("\n");
          return(1);
     }
     cursiz(GVIDNOCURS);
     incfil=alczer(FNEXSZ);
     if (!isdir(INCDIR)) {
          gmkdir(INCDIR);
     }
     fileparts(GCPART_FNAM,argv[1],tmppath,sizeof(tmppath));
     stzcpy(incfil,cnv2is(tmppath),FNEXSZ);
     if (isfile(spr("%s\\%s",INCDIR,incfil))) {
          if (unlink(spr("%s\\%s",INCDIR,incfil)) == -1) {
               catastro("Error deleting old compressed file!");
          }
     }
     setatr(0x0E);

#ifdef GCDOS
     if ((retcod=spawnl(P_WAIT,PRGNAM,NOARG,argv[1],spr("%s\\%s",INCDIR,incfil),
                 argv[2],NULL)) == -1) {
          catastro("Error spawning WGSISCOM.EXE!");
     }
#else
     memset(&si,0,sizeof(STARTUPINFO));
     si.cb=sizeof(STARTUPINFO);
     si.dwFlags=STARTF_USESTDHANDLES;
     sprintf(cmdbuf,"%s %s %s %s",PRGNAM,argv[1],
             spr("%s\\%s",INCDIR,incfil),argv[2]);
     if (CreateProcess(PRGNAM,cmdbuf,NULL,NULL,FALSE,CREATE_DEFAULT_ERROR_MODE,
                       NULL,NULL,&si,&pi)) {
          WaitForSingleObject(pi.hProcess,INFINITE);
          GetExitCodeProcess(pi.hProcess,(LPDWORD)&procrc);
          CloseHandle(pi.hProcess);
          CloseHandle(pi.hThread);
          if (procrc != 0) {
               catastro("Error launching %s (error %d)!",PRGNAM,(INT)procrc);
          }
     }
     else {
          catastro("CreateProcess error launching %s (error %d)!",PRGNAM,
                   (INT)GetLastError());
     }
#endif

#ifdef GCDOS
     if (retcod == EXITOK) {
#else
     if (procrc == 0) {
#endif
          printf("\n\n");
          printf("%s will now be included on your client distribution disks.\n",
                  fnmcse(tmppath));
     }
     setatr(0x07);
     printf("\r");
     cursiz(GVIDLILCURS);
     return(0);
EXCEPT
#ifdef GCWINNT
     return(2);
#endif // GCWINNT
}
