/***************************************************************************
 *                                                                         *
 *   CNV2IS.C                                                              *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.  All rights reserved.       *
 *                                                                         *
 *   This utility converts a file name to the "underscore" format used     *
 *   by InstallSHIELD.  A pointer to the converted file name is returned.  *
 *                                                                         *
 *                                                - C. Dunn  1/3/95        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

#define FILREV "$Revision: 4 $"

#define EXTFIL ".___"              /* extension "filler"                   */

CHAR *                             /*   returns ptr to converted file name */
cnv2is(                            /* convert file name to I-shield format */
CHAR *filnam)                      /*   file name to convert               */
{
     INT i,count;
     CHAR *ptr;
     static CHAR tmpnam[FNEXSZ];

     stzcpy(tmpnam,filnam,FNEXSZ);
     if (strchr(tmpnam,'.') == NULL) {
          return(stzcat(tmpnam,EXTFIL,FNEXSZ));
     }
     count=strlen(tmpnam)-2;
     for (i=FNEXSZ-2 ; i > count ; i--) {
          if (tmpnam[i] == '.') {
               break;
          }
          tmpnam[i]='_';
     }
     if (strlen(ptr=strchr(tmpnam,'.')) > MAXEXT-1) {
          ptr[4]='\0';
     }
     return(tmpnam);
}
