/***************************************************************************
 *                                                                         *
 *   BBSFNDO.C                                                             *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This program finds all lines in all active .MDF files that begin      *
 *   with the command-line argument, and executes each of the commands     *
 *   found there, in turn.  It depends on the file WGSMDFS.LST, which      *
 *   is created by WGSINT.                                                 *
 *                                                                         *
 *                                            - T. Stryker 3/15/92         *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"

#define FILREV "$Revision: 7 $"

INT
main(                              /* find commands in MDFs, and do them   */
INT argc,
CHAR *argv[])
{
TRY
     FILE *afp,*mdffp;
     INT exicode,nacts,i;
     CHAR mdfbuf[100],*mp;

#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#endif // GCWINNT
     initvid();
     if ((exicode=setjmp(disaster)) != 0) {
          locate(0,23);
          return(exicode);
     }
     monorcol();
     if (argc != 2) {
          setatr(0x0E);
          printf("Command format is: WGSFNDO <line-id>");
          return(1);
     }
     if ((afp=fopen("wgsmdfs.lst",FOPRA)) == NULL) {
          catastro("WGSFNDO: CAN'T READ \"WGSMDFS.LST\"");
     }
     if (fscanf(afp,"%d",&nacts) != 1) {
          catastro("WGSFNDO: ERROR READING COUNT IN \"WGSMDFS.LST\"");
     }
     for (i=0 ; i < nacts ; i++) {
          if (fscanf(afp,"\n%12s",mdfbuf) != 1) {
               catastro("WGSFNDO: ERROR READING NAME IN \"WGSMDFS.LST\"");
          }
          if ((mdffp=fopen(mdfbuf,FOPRA)) == NULL) {
               catastro("WGSFNDO: CAN'T READ \"%s\"",mdfbuf);
          }
          while (fgets(mdfbuf,sizeof(mdfbuf),mdffp) != NULL) {
               if (sameto(argv[1],mdfbuf)) {
                    unpad(mdfbuf);
                    mp=mdfbuf+strlen(argv[1]);
                    if (*mp == ':') {
                         mp++;
                    }
                    if (*mp != '\0') {
                         system(skpwht(mp));
                    }
               }
          }
          fclose(mdffp);
     }
     fclose(afp);
     clsvid();
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}
