/***************************************************************************
 *                                                                         *
 *   WGSDRAW.C                                                             *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   This is the ANSI screen builder for use with the server, callable     *
 *   from the DOS command line.                                            *
 *                                                                         *
 *                       - S. Brinker & T. Stryker    01/21/92             *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "mdlogic.h"
#include "excphand.h"

#define FILREV "$Revision: 11 $"

INT main(INT argc,CHAR *argv[]);
VOID ex2dos(INT c);

#ifdef GCWINNT
const CHAR helpfn[]="help\\wgscnf.hlp"; /* help file name                  */
static const ULONG helpid=131331;  /* WGSDRAW help ID in wgscnf.hlp        */
#endif // GCWINNT

INT
main(
INT argc,
CHAR *argv[])
{
TRY
     CHAR fnbuff[100];
#ifdef GCWINNT
     GBOOL runAnyway=FALSE;

     if ((argc > 2) && sameas(argv[2],"-run")) {
          runAnyway=TRUE;
     }
     if ((!runAnyway) && !canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
     initWinHelp(helpfn,helpid);   /* tell mdmain where to find help       */
#endif // GCWINNT
     initvid();
     monorcol();
     if (argc < 2) {
          fprintf(stderr,"Enter filename to edit: ");
          if (fgets(fnbuff,sizeof(fnbuff),stdin) == NULL) {
               exit(1);
          }
          if (fnbuff[strlen(fnbuff)-1] == '\n') {
               fnbuff[strlen(fnbuff)-1]='\0';
          }
          mdmtdraw(fnbuff,1,ex2dos);
     }
     else {
          mdmtdraw(argv[1],1,ex2dos);
     }
     scblank(0,0x07);
     locate(0,24);
     clsvid();
#ifdef GCWINNT
     closeWinHelp();
#endif // GCWINNT
     return(0);
EXCEPT
#ifdef GCWINNT
     closeWinHelp();
     return(1);
#endif // GCWINNT
}

VOID
ex2dos(
INT c)
{
     switch (c) {
     case ESC:
          mdesc();
          break;
     case ALT_X:
          if (!xmdnow()) {
               exitmd();
          }
          break;
     case ALT_S:
          savemd();
          rfrscn();
          break;
     }
}
