/***************************************************************************
 *                                                                         *
 *   MDLOFF.C                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   This is the WGSDRAW interface for the offline WGSDRAW.EXE.            *
 *                                                                         *
 *                       - S. Brinker & T. Stryker    03/24/92             *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "mdlogic.h"

CHAR *ynschc[]={"Yes","No","Save",NULL};

VOID
mdmtdraw(fpassd,shoid,exirou)
CHAR *fpassd;
INT shoid;
VOID (*exirou)();
{
     INT i,try1st;
     CHAR *sptr,*ptr;

     inimdl();
     if (markers == NULL) {
          markers=(struct marker *)alcmem(sizeof(struct marker)*MXMARK);
     }
     nmarks=0;
     fnmcse(fpassd);
     if ((sptr=strrchr(fpassd,'.')) == NULL) {
          try1st=IBMFIL;
     }
     else {
          switch (toupper(*(sptr+2))) {
          case 'N':
               try1st=ANSFIL;
               break;
          case 'S':
               try1st=ASCFIL;
               break;
          default:
               try1st=IBMFIL;
               break;
          }
          *sptr='\0';
     }
     if (strlen(fpassd) > 75) {
          fpassd[75]='\0';
     }
     strcpy(filnam,fpassd);
     for (i=0 ; i < 3 ; i++) {
          if (mdload(0,spr("%s.%s",fpassd,tryext[try1st][i]))) {
               break;
          }
     }
     mem2scn(scnbuf,0,GVIDSCNSIZ);
     setwin(0L,ULX,ULY,LRX,LRY,scropt);
     shwqrf();
     gcdelay(0);
     if (shoid) {
          intro();
     }
     explode(scntbl[COLSCN],28,17,51,19);
     setatr(0x1B);
     if (i == 3) {
          locate(30,18);
          printf("   No file found.");
     }
     else {
          ptr=spr("%s loaded.",(sptr=strrchr(filnam,'\\')) == NULL ? filnam
                               : sptr+1);
          locate(30+(20-strlen(ptr))/2,18);
          printf("%s",ptr);
     }
     hidecursor();
     for (i=0 ; i < 350 ; i++) {
          gcdelay(10);
          if (kbhit()) {
               getchc();
               break;
          }
     }
     mdmain(1,exirou);
}

VOID
exitmd(VOID)
{
     CHAR ynsans[5];

     strcpy(ynsans,"Yes");
     scn2mem(tmpbuf,0,GVIDSCNSIZ);
     explode(scntbl[ERRSCN],20,8,57,10);
     if (edtchc(51,9,ynsans,ynschc,0)) {
          switch (ynsans[0]) {
          case 'S':
               savemd();
               if (edtvalc == ESC) {
                    return;
               }
          case 'Y':
               mddone=1;
               return;
          }
     }
     rfrscn();
}

VOID
savemd(VOID)
{
#define SFNSTT      1              /* save as what filename? state         */
#define SCSSTT      2              /* save with clear screen? state        */
     static CHAR sfname[40];
     CHAR *sptr;
     FILE *fp;

     explodeto(scntbl[ERRSCN],18,14,79,16,9,11);
     stzcpy(sfname,filnam,sizeof(sfname)-4);
     fnmcse(sfname);
     if ((sptr=strrchr(sfname,'.')) != NULL) {
          *sptr='\0';
     }
     if (needibm()) {
          strcat(sfname,".ibm");
     }
     else if (needans()) {
          strcat(sfname,".ans");
     }
     else {
          strcat(sfname,".asc");
     }
     while (edtval(30,12,sizeof(sfname),sfname,valfln,
             needupc() ? ALLCAPS : 0)) {
          if ((fp=fopen(sfname,FOPWA)) != NULL) {
               fclose(fp);
               if (strstr(sfname,".asc") != NULL) {
                    saveasc(sfname);
               }
               else if (strstr(sfname,".bin") != NULL) {
                    savebin(sfname);
               }
               else {
                    saveans(sfname);
               }
               strcpy(filnam,sfname);
               changed=0;
               break;
          }
          printf("\7");
     }
     rfrscn();
}

INT
needibm(VOID)
{
     INT i;
     CHAR *sp;

     for (sp=scnbuf,i=0 ; i < GVIDSCNSIZ/2 ; sp+=2,i++) {
          if (*sp > 127) {
               return(1);
          }
     }
     return(0);
}

INT
needans(VOID)
{
     INT i;
     CHAR *sp;

     for (sp=scnbuf,i=0 ; i < GVIDSCNSIZ/2 ; sp+=2,i++) {
          if (*(sp+1) != 0x07 && tvinxy(i%80,i/80) == NULL) {
               return(1);
          }
     }
     return(finalx != -1);
}

VOID
savebin(savnam)
CHAR *savnam;
{
     FILE *sfp;

     if ((sfp=fopen(savnam,FOPWB)) == NULL) {
          catastro("Couldn't open %s for writing.\n",savnam);
     }
     if (fwrite(scnbuf,GVIDSCNSIZ/2,2,sfp) != 2) {
          catastro("Error writing %s\n",savnam);
     }
     fclose(sfp);
}

VOID
saveasc(savnam)
CHAR *savnam;
{
     FILE *sfp;
     CHAR *sp;
     INT ix,iy,inkm4x=-1;
     struct marker *mptr;
     struct txtvar *vptr;

     if ((sfp=fopen(savnam,FOPWB)) == NULL) {
          catastro("Couldn't open %s for writing.\n",savnam);
     }
     if (savwcs) {
          fputc(12,sfp);
     }
     for (iy=0 ; iy < 25 ; iy++) {
          sp=scnbuf+gvscnoff(0,iy);
          for (ix=0 ; ix < 80 ; ix++,sp+=2) {
               if (inkm4x == -1 && (mptr=kminxy(ix,iy)) != NULL) {
                    fputc(MARKCH,sfp);
                    fputc(mptr->select,sfp);
                    inkm4x=mptr->endx;
               }
               if ((vptr=tvinxy(ix,iy)) != NULL) {
                    fputc(TVARCH,sfp);
                    fputc(justbl[(SHORT)vptr->just][0],sfp);
                    fputc(vptr->length+32,sfp);
                    fprintf(sfp,vptr->name);
                    fputc(TVARCH,sfp);
                    ix+=vptr->length-1;
                    sp+=(vptr->length-1)*2;
                    if (inkm4x != -1 && ix >= mptr->endx && (ix != 79 || mptr->startx != 0)) {
                         fputc(MARKCH,sfp);
                         inkm4x=-1;
                    }
                    if (ix == 79 && iy != 24) {
                         if (endscn(iy+1)) {
                              iy=24;
                         }
                         else {
                              fputc('\r',sfp);
                              fputc('\n',sfp);
                         }
                    }
                    continue;
               }
               if (!stoeol(ix,iy) || !(inkm4x == -1 || (mptr->startx == 0
                   && mptr->endx == 79))) {
                    fputc(*sp,sfp);
               }
               if (inkm4x != -1) {
                    if (mptr->endx == ix && (ix != 79 || mptr->startx != 0)) {
                         fputc(MARKCH,sfp);
                         inkm4x=-1;
                    }
               }
               if ((ix == 79 && iy != 24) || stoeol(ix,iy)) {
                    if (inkm4x == -1 || (mptr->startx == 0 &&
                                         mptr->endx == 79)) {
                         inkm4x=-1;
                         if (endscn(iy+1)) {
                              iy=24;
                         }
                         else {
                              fputc('\r',sfp);
                              fputc('\n',sfp);
                         }
                         if (ix != 79) {
                              break;
                         }
                    }
               }
          }
     }
     fclose(sfp);
}

INT
getchq(VOID)
{
     return(getchc());
}
