/***************************************************************************
 *                                                                         *
 *   DFCVERIF.H                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Conversion file template verify routines.                             *
 *                                                                         *
 *                                           - Wally Muharsky 10/20/97     *
 *                                                                         *
 ***************************************************************************/
#ifndef __DFCVERIF_H
#define __DFCVERIF_H

#include "DFCAPI2.H"

#ifdef __cplusplus
extern "C" {
#endif

#define DFCBUFSIZ        2000      /*  Internal buffer size                */
#define DFC_PLATFORMS    2         /*  Number of platforms                 */
#define DFC_REMARK       ';'       /*  Use as a rem statement in templates */
#define CNV_TYPES        7         /*  Number of conversion types          */

/***************************************************************************
 * Error Codes                                                             *
 ***************************************************************************/
#define DFC_SUCCESS           0    /*  Everything is well                  */
#define DFC_NOFILE            1    /*  File not found                      */
#define DFC_FILEOPEN          2    /*  Unable to open file                 */
#define DFC_ENDOFFILE         3    /*  Read past end of file               */
#define DFC_BUFFERSIZE        4    /*  Read out too much at once (no CR)   */
#define DFC_TWODESCRIPTIONS   5    /*  Two descriptions in template        */
#define DFC_TWOCUSTOMCONVERTS 6    /*  Two Custom conversions in template  */
#define DFC_TWODEVELOPERS     7    /*  Two developers in template          */
#define DFC_NOBEGINFILE       8    /*  No BeginFile in template            */
#define DFC_UNKNOWNTEXT       9    /*  Unknown text in template            */
#define DFC_CUSTOMNOTFOUND    10   /*  Custom file not found               */
#define DFC_BEGINARGS         11   /*  Invalid amount of begin arguments   */
#define DFC_INVALIDPLATFORM   12   /*  Platform not recognized             */
#define DFC_INVALIDFILENAME   13   /*  Invalid filename in begin file      */
#define DFC_INVALIDFILEFORMAT 14   /*  Remove the "." from the filename    */
#define DFC_INVALIDFIELDNAME  15   /*  Invalid data name size=0 or > max   */
#define DFC_FIELDNAMEEXISTS   16   /*  Datafield name already exists       */
#define DFC_INVALIDTYPE       17   /*  Invalid data type                   */
#define DFC_INVALIDPARAMATER  18   /*  Invalid paramater on line (no '=')  */
#define DFC_TYPEDEFINED       19   /*  Type already defined                */
#define DFC_PARAMBEFORETYPE   20   /*  Paramater encountered before TYPE=  */
#define DFC_ELEMENTSDEFINED   21   /*  Elements are already defined        */
#define DFC_INVALIDELEMENTS   22   /*  Invalid number of elements          */
#define DFC_NOENDSTRUCTURE    23   /*  No end structure                    */
#define DFC_NODESCRIPTION     24   /*  No description found                */
#define DFC_NODEVELOPER       25   /*  No developer found                  */
#define DFC_NULLFILE          26   /*  No elements in file                 */
#define DFC_NULLSTRUCT        27   /*  No elements in structure            */
#define DFC_NOTYPEDEFINED     28   /*  NO type defined                     */
#define DFC_INITIALIZED       29   /*  Program already initied (needs free)*/
#define DFC_JUSTIFYTRUNCATE   30   /*  JUSTIFY and TRUNCATE (not both)     */
#define DFC_TRUNCATESET       31   /*  TRUNCATE already set                */
#define DFC_JUSTIFYSET        32   /*  JUSTIFY already set                 */
#define DFC_UNKNOWNJUSTIFY    33   /*  Unknown justify command             */
#define DFC_UNKNOWNTRUNCATE   34   /*  Unknown truncation                  */
#define DFC_PADBEFOREJUSTIFY  35   /*  Pad found before justify            */
#define DFC_INVALIDPADVALUE   36   /*  Invalid pad value                   */
#define DFC_VARIABLE_LAST     37   /*  Variable records are defined last   */
#define DFC_VARIABLE_STRUCT   38   /*  Can not have variable structures    */
#define DFC_TWOMODULENAMES    39   /*  Two module names defined            */

/***************************************************************************
 * Variable declarations                                                   *
 ***************************************************************************/
extern CHAR *Platforms[];

static struct cnvTypes {           /*  Conversion type information         */
     CHAR *Type;                   /*  Data type                           */
     INT cnvType;                  /*  Matching DFC #define                */
};

extern struct cnvTypes ConversionTypes[];
extern CHAR dfcbuf[DFCBUFSIZ];

#define DFCFIELD_VARIABLE          1    /*  Variable length field          */
#define DFCFIELD_TRUNCATE_RIGHT    2    /*  Truncate to the right          */
#define DFCFIELD_TRUNCATE_LEFT     4    /*  Truncate to the left           */
#define DFCFIELD_JUSTIFY_LEFT      8    /*  Justify from the left side     */
#define DFCFIELD_JUSTIFY_RIGHT     16   /*  Justify from the right side    */

typedef struct tagDFCFIELDINFO {   /* Field information                    */
     CHAR Name[DFC_NAMSIZ];        /*  Variable name                       */
     INT Flags;                    /*  Above #defines                      */
     LONG MaxElems;                /*  Maximum elements                    */
     CHAR Pad;                     /*  Padding character                   */
} DFCFIELDINFO,*pDFCFIELDINFO;

typedef struct tagDFCCVTFILE {     /*  Conversion file information         */
     CHAR File[GCMAXPTH];          /*  Full file and path                  */
     CHAR *Description;            /*  Description of conversion           */
     CHAR *Developer;              /*  Description of developer            */
     CHAR *CustomProgram;          /*  Custom conversion program           */
     CHAR *ModuleName;             /*  Generic module name                 */
     pDFCLIST fillst;              /*  Pointer to in memory list of files  */
     GBOOL Generic;                /*  Generic database                    */
} DFCCVTFILE,*pDFCCVTFILE;

extern DFCCVTFILE cf;              /*  Current conversion file             */

extern INT LinesRead;              /*  Number of lines read in template    */

/***************************************************************************
 * Exported functions                                                      *
 ***************************************************************************/
pDFCFIELDINFO                      /*  Pointer to datafield                */
dfcGetFieldInfo(                   /* Get field information                */
INT Platform,                      /*  Platform (DOS/WNT)                  */
const CHAR *FileName,              /*  Name of the datafile                */
const CHAR *ItemName);             /*  Name of the item to search for      */

CHAR *                             /*  Pointer to error string             */
dfcErrorStg(                       /* Get meaning given error number       */
INT ErrorNumber);                  /*  Error number to search for          */

INT                                /*  0 on success, other #defines on err */
dfcVerifyFile(                     /* Verify conversion template file      */
const CHAR *File);                 /*  File to verify                      */

VOID
dfcVerifyFree(VOID);               /*  Free up everything allocated        */

#ifdef __cplusplus
extern "C" {
#endif
#endif //__DFCVERIF_H

