/***************************************************************************
 *                                                                         *
 *   WGSAPPGO.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This program controls the running of the Worldgroup Server when       *
 *   running as an application.                                            *
 *                                                                         *
 *                                        - Richard Skurnick 06/11/96      *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "excphand.h"
#include "runapp.h"

#define FILREV "$Revision: 15 $"

INT WINAPI
WinMain(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     CHAR *pTmp;
     CHAR path[2048];
     INT retVal;
     CHAR runBuffer[80];
     CHAR msgBuffer[80];
     GBOOL done=FALSE;
     INT errcod;
     GBOOL fFirstTime=TRUE;
     CHAR *startApp;

     (VOID)hPrevInstance;
     (VOID)lpCmdLine;
     (VOID)nCmdShow;
     GetModuleFileName(hInstance,path,sizeof(path));
     if ((pTmp=strrchr(path,'\\')) != NULL
          || (pTmp=strrchr(path,'/')) != NULL) {
          *pTmp='\0';
          chdir(path);
          *pTmp='\\';
     }
     while (!done) {
          if (fFirstTime) {
               fFirstTime=FALSE;
               startApp="wgsysup YES";
          }
          else {
               startApp="wgsysup NO";
          }
          if (!runApp(startApp,NULL,SW_SHOWDEFAULT,&retVal)) {
               MessageBox(NULL,"Unable to execute WGSYSUP.EXE!",path,
                         MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
               return(1);
          }
          if (retVal != 0) {            // WGSYSUP can't proceed so abort
               return(retVal);
          }
          if (isfile("wgsridx.flg")) {
               unlink("wgsridx.flg");
               return(1);
          }
          if (!runApp("wgserver -runapp",SVR_FULL,SW_SHOWMINIMIZED,&retVal)) {
               MessageBox(NULL,"Unable to execute WGSERVER.EXE!",path,
                          MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
               return(1);
          }
          switch(retVal) {
          case 99:
          case 90:
          case 80:
          case 70:
          case 50:
          case 49:
          case 14:
          case 13:
          case 12:
          case 11:
          case 8:
          case 1:
          case 0:
               sprintf(runBuffer,"wgsysdn %d",retVal);
               break;
          default:
               sprintf(msgBuffer,"Unrecognized errorlevel=%d returned from WGSERVER.EXE!",
                                 retVal);
               MessageBox(NULL,msgBuffer,path,MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
               return(1);
          }
          if (!runApp(runBuffer,NULL,SW_SHOWDEFAULT,&retVal)) {
               MessageBox(NULL,"Unable to execute WGSYSDN.EXE!",path,
                          MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
               return(1);
          }
          switch (retVal) {        // figure out possibilities and put here
          case 0:                  // exit to OS - no error
               done=TRUE;
               errcod=0;
               break;
          case 1:                  // do nothing run WGSERVER.EXE again
               break;
          case 2:                  // exit to OS - error occured
          case 3:                  // exit to OS - WGSYSDN faulted
          case 99:                 // exit to OS - invalid value sent to WGSYSDN
               done=TRUE;
               errcod=1;
               break;
          default:
               sprintf(msgBuffer,"Unrecognized errorlevel=%d returned from WGSYSDN.EXE!",
                                 retVal);
               MessageBox(NULL,msgBuffer,path,MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
               done=TRUE;
               errcod=1;
          }
     }
     return(errcod);
EXCEPT
     return(99);
}

#if 0

     These error codes are used by WGSAPPGO and WGSYSDN

     0 = Successful shutdown, run server again
     1 = Successful shutdown, stop running WGSAPPGO
     2 = Unsuccessful shutdown, stop running WGSAPPGO
     3 = WGSYSDN Faulted
     99 = invalid error code passed to WGSYSDN

#endif // if 0
