/***************************************************************************
 *                                                                         *
 *   BBSRBX.C                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   This is WGSXRF2.DAT rebuilder utility for the server.                 *
 *                                                                         *
 *                                                - C. Robert  05/06/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "integrou.h"
#include "excphand.h"

#define FILREV "$Revision: 9 $"

extern CHAR scntbl[][GVIDSCNSIZ];  /* table of screens (c/o MAKESCNS)      */
static CHAR dosscn[GVIDSCNSIZ];    /* saved DOS screen image               */

DFAFILE *xrfbb;                    /* BTRIEVE file pointer to WGSXRF2.DAT  */

VOID zeroxrf(VOID),addxrfs(VOID),shouid(CHAR *uid),addxrf(CHAR *uid),
     shoxrf(CHAR *xrf);

INT
main(
INT argc,
CHAR *argv[])
{
TRY
     (VOID)argc;
#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#else
     (VOID)argv;
#endif // GCWINNT
     initvid();
     scn2mem(dosscn,0,GVIDSCNSIZ);
     monorcol();
     cvtscn(scntbl[0]);
     explode(scntbl[0],21,6,56,10);
     cursiz(GVIDNOCURS);
     xrfbb=dfaOpen("wgsxrf2.dat",sizeof(struct uidxrf),NULL);
     zeroxrf();
     mem2scn(dosscn,0,GVIDSCNSIZ);
     explode(scntbl[0],6,12,72,16);
     setatr(0x30);
     addxrfs();
     dfaClose(xrfbb);
     setatr(0x07);
     printf(" ");
     locate(0,24);
     mem2scn(dosscn,0,GVIDSCNSIZ);
     cursiz(1);
     clsvid();
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif

}

VOID
zeroxrf(VOID)                      /* zero out the WGSXRF2.DAT file        */
{
     if (dfaQueryLO(0)) {
          do {
               dfaAbsRec(NULL,0);
               dfaDelete();
          } while (dfaQueryNX());
     }
}

VOID
addxrfs(VOID)                      /* add in all xrefs (as per WGSUSR2.DAT)*/
{
     DFAFILE *accbb;
     struct usracc tmpacc;

     accbb=dfaOpen("wgsusr2.dat",sizeof(struct usracc),NULL);
     if (dfaQueryLO(0)) {
          dfaAbsRec(NULL,0);
          do {
               movmem(accbb->data,&tmpacc,sizeof(struct usracc));
               shouid(tmpacc.userid);
               addxrf(tmpacc.userid);
          } while (dfaQueryNX());
     }
     dfaClose(accbb);
}

VOID
shouid(                            /* show a user-id on the screen now     */
CHAR *uid)                         /*   user-id to display                 */
{
     locate(17,14);
     printf("%-29s",uid);
}

VOID
addxrf(                            /* add one uid's x-refs now             */
CHAR *uid)                         /*   user-id to add x-refs for          */
{
     struct uidxrf uidxrf;
     CHAR *bas,*ptr,savchr;

     dfaSetBlk(xrfbb);
     setmem(&uidxrf,sizeof(struct uidxrf),0);
     stzcpy(uidxrf.userid,uid,UIDSIZ);
     bas=ptr=uid;
     do {
          bas=skpwht(bas);
          while (*ptr != '\0' && ptr-bas < XRFSIZ) {
               ptr++;
          }
          savchr=*ptr;
          *ptr='\0';
          stzcpy(uidxrf.xrfstg,bas,XRFSIZ);
          *ptr=savchr;
          shoxrf(uidxrf.xrfstg);
          uidxrf.xrfstg[XRFSIZ]=(sameas(uidxrf.xrfstg,uidxrf.userid) ? 0 : 1);
          dfaInsert(&uidxrf);
     } while (*(bas=ptr=skpwrd(bas)) != '\0');
     dfaRstBlk();
}

VOID
shoxrf(                            /* show a x-ref on the screen now       */
CHAR *xrf)                         /*   cross-ref to display               */
{
     locate(54,14);
     printf("%-15s",xrf);
}
