/***************************************************************************
 *                                                                         *
 *   BBSRBK.C                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   This is WGSKEY2.DAT rebuilder utility for the server.                 *
 *                                                                         *
 *                                                - C. Robert  10/27/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "excphand.h"

#define FILREV "$Revision: 9 $"

extern CHAR scntbl[][GVIDSCNSIZ];/* table of screens (c/o MAKESCNS)*/
static CHAR dosscn[GVIDSCNSIZ];    /* saved DOS screen image               */

DFAFILE *accbb,*keybb,*clsbb;      /* BTRIEVE file pointers                */

struct usracc tmpacc;              /* temporary user account record        */
struct acclass tmpcls;             /* temporary account class record       */
CHAR tmpkey[RINGSZ];               /* temporary keyring record             */

INT
main(
INT argc,
CHAR *argv[])
{
TRY
     FILE *fp;
     CHAR clsnam[UIDSIZ];

     (VOID)argc;
#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#else
     (VOID)argv;
#endif // GCWINNT
     initvid();
     scn2mem(dosscn,0,GVIDSCNSIZ);
     monorcol();
     cvtscn(scntbl[0]);
     explode(scntbl[0],21,6,55,10);
     cursiz(GVIDNOCURS);
     keybb=dfaOpen("wgskey2.dat",RINGSZ,NULL);
     setmem(tmpkey,RINGSZ,0);
     if ((fp=fopen("wgskyr.fxd",FOPWA)) == NULL) {
          catastro("CAN'T OPEN \"WGSKYR.FXD\" FOR OUTPUT!");
     }
     accbb=dfaOpen("wgsusr2.dat",sizeof(struct usracc),NULL);
     if (dfaQueryLO(0)) {
          dfaAbsRec(NULL,0);
          do {
               movmem(accbb->data,&tmpacc,sizeof(struct usracc));
               dfaSetBlk(keybb);
               if (!dfaQueryEQ(tmpacc.userid,0)) {
                    stzcpy(tmpkey,tmpacc.userid,UIDSIZ);
                    fprintf(fp,"%s\n",tmpkey);
                    dfaInsertV(tmpkey,UIDSIZ+1);
               }
               dfaRstBlk();
          } while (dfaQueryNX());
     }
     dfaClose(accbb);
     clsbb=dfaOpen("wgsclas2.dat",sizeof(struct acclass),NULL);
     if (dfaQueryLO(0)) {
          dfaAbsRec(NULL,0);
          do {
               movmem(clsbb->data,&tmpcls,sizeof(struct acclass));
               stzcpy(clsnam,"&",UIDSIZ);
               strcat(clsnam,tmpcls.clname);
               dfaSetBlk(keybb);
               if (!dfaQueryEQ(clsnam,0)) {
                    stzcpy(tmpkey,clsnam,UIDSIZ);
                    fprintf(fp,"%s\n",tmpkey);
                    dfaInsertV(tmpkey,UIDSIZ+1);
               }
               dfaRstBlk();
          } while (dfaQueryNX());
     }
     dfaClose(clsbb);
     fclose(fp);
     dfaClose(keybb);
     locate(0,24);
     mem2scn(dosscn,0,GVIDSCNSIZ);
     cursiz(1);
     clsvid();
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}
