/***************************************************************************
 *                                                                         *
 *   WGSZSTAT.C                                                            *
 *                                                                         *
 *   Copyright (c) 1991-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the utility to zero monthly statistics.                       *
 *                                                                         *
 *                                                  - C. Robert 3/4/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "excphand.h"

#define FILREV "$Revision: 8 $"

static CHAR dosscn[GVIDSCNSIZ];/* saved DOS screen image                   */

INT total=0;                  /* zero-out total stats?                     */

struct sysvbl sv;             /* system variable structure #1              */
struct sysvb2 sv2;            /* system variable structure #2              */
struct sysvb3 sv3;            /* system variable structure #3              */

extern CHAR scntbl[][GVIDSCNSIZ]; /* array of screens (c/o MAKESCNS)       */

static VOID zeroem(VOID),zeromac(VOID);

INT
main(argc,argv)                    /* main program loop                    */
INT argc;
CHAR *argv[];
{
TRY
     CHAR *chcs[]={
          "Zero-out monthly statistics only",
          "Zero-out monthly and total stats"
     };

#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#endif // GCWINNT
     initvid();
     cursiz(GVIDNOCURS);
     scn2mem(dosscn,0,GVIDSCNSIZ);
     monorcol();
     cvtscn(scntbl[0]);
     if (argc > 1 && sameas(argv[1],"-NOPROMPT")) {
          zeroem();
     }
     else {
          explode(scntbl[0],18,6,61,21);
          proff(0,0);
          selatr=0x7E;
          nslatr=0x3E;
          if ((total=choose(2,chcs,23,18,56,19,TRUE)) != -ESC) {
               proff(0,0);
               zeroem();
          }
     }
     setatr(0x07);
     printf(" ");
     locate(0,24);
     mem2scn(dosscn,0,GVIDSCNSIZ);
     cursiz(GVIDLILCURS);
     clsvid();
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}

static VOID
zeroem(VOID)                       /* go ahead and zero the stats          */
{
     INT i,j;
     DFAFILE *svbb;

     explodeto(scntbl[0],0,0,28,4,25,10);
     svbb=dfaOpen("wgsvbl2.dat",sizeof(struct sysvb3),NULL);
     dfaGetEQ(&sv,"key",0);
     dfaGetEQ(&sv2,"ky2",0);
     dfaGetEQ(&sv3,"ky3",0);
     if (total) {
          sv.dwnlds=0L;
          sv.uplds=0L;
          sv2.x25kps=0L;
          sv2.x25ps=0;
          sv2.x25mbs=0L;
          sv2.x25bs=0L;
          sv2.paidpst=0L;
          sv2.freepst=0L;
          sv2.totcalls=0L;
     }
     for (i=0 ; i < 8 ; i++) {
          sv.calls[i]=0L;
     }
     for (i=0 ; i < NUMGRPS-1 ; i++) {
          for (j=0 ; j < 24 ; j++) {
               sv3.secghr[i][j]=0L;
               sv3.crdghr[i][j]=0L;
          }
     }
     for (i=0 ; i < 48 ; i++) {
          sv2.nliniu[i]=0;
     }
     sv2.lstzer=today();
     dfaGetEQ(NULL,"key",0);
     dfaUpdateV(&sv,sizeof(struct sysvbl));
     dfaGetEQ(NULL,"ky2",0);
     dfaUpdateV(&sv2,sizeof(struct sysvb2));
     dfaGetEQ(NULL,"ky3",0);
     dfaUpdateV(&sv3,sizeof(struct sysvb3));
     dfaClose(svbb);
     zeromac();
}

static VOID
zeromac(VOID)                      /* zero module and class statistics     */
{
     DFAFILE *bbptr;
     struct mdstats tmpmd;
     struct acclass tmpcl;

     bbptr=dfaOpen("wgsstat2.dat",sizeof(struct mdstats),NULL);
     if (dfaQueryLO(0)) {
          dfaAbsRec(NULL,0);
          do {
               movmem(bbptr->data,&tmpmd,sizeof(struct mdstats));
               tmpmd.creds=0L;
               tmpmd.seconds=0L;
               dfaUpdate(&tmpmd);
          } while (dfaQueryNX());
     }
     dfaClose(bbptr);
     bbptr=dfaOpen("wgsclas2.dat",sizeof(struct acclass),NULL);
     if (dfaQueryLO(0)) {
          dfaAbsRec(NULL,0);
          do {
               movmem(bbptr->data,&tmpcl,sizeof(struct acclass));
               tmpcl.seconds=0L;
               dfaUpdate(&tmpcl);
          } while (dfaQueryNX());
     }
     dfaClose(bbptr);
}
