/***************************************************************************
 *                                                                         *
 *   WGSUMENU.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   This utility handles listing all the offline utilities.  The Sysop    *
 *   can then select a utility to run.                                     *
 *                                                                         *
 *                                          Richard Skurnick  05/21/96     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"

#define FILREV "$Revision: 9 $"

#define NUMSCNS     1                   /* number of screens in scntbl[]   */
extern CHAR scntbl[NUMSCNS][GVIDSCNSIZ];/* table of mem-resident screens   */

static CHAR savscn[GVIDSCNSIZ];         /* save original screen            */

struct utils {                          /* utilities used structure        */
     CHAR utlName[10];                  /*   name of utility               */
     CHAR utlDesc[64];                  /*   description of utility        */
} stdUtils[]={
     {"WGSMKWGM",   "Worldgroup Manager packaging utility"                 },
     {"GALFOMAN",   "offline Forums management utility"                    },
     {"WGSRPT  ",   "menu of reports on the server, users, etc."           },
     {"WGSRIDX ",   "restore file integrity if questionable"               },
     {"WGSRDRLN",   "read release note files"                              },
     {"WGSSWTCL",   "move all users in one class to another"               },
     {"WGSDMOD ",   "disable or re-enable selected modules"                },
     {"WGSAREF ",   "App-ID reference by module name"                      },
     {"GALPNQR ",   "generate report on questionnaire results"             },
     {"WGSMREF ",   "modem settings reference guide"                       },
     {"GALFILIN",   "log files into library"                               },
     {"WGSCLRAT",   "clear Audit Trail"                                    },
     {"WGSZSTAT",   "clear statistics used in Sysop displays"              },
     {"GALFILKW",   "re-build file library keyword database"               },
     {"WGSSETCL",   "re-establish basic underlying system type"            },
     {"WGSLANG ",   "add, delete, or export user languages"                },
     {"WGSCOLOR",   "change colors used online"                            },
     {"GALRFC  ",   "combine RIP files for online viewing"                 }
};

#define STDCNT      (sizeof(stdUtils)/sizeof(struct utils))

#define UTILINC     5              /* number increment counter             */

struct xitList {
     CHAR utilName[9];
};

static struct xitList xit1List[]={
     {"WGSMKWGM"    }
};

static struct xitList xit2List[]={
     {"GALFOMAN"    },
     {"WGSRPT"      }
};

static INT  numUtils,              /* number of offline utilities in use   */
            maxIndex;              /* maximum number of utilities allocated*/
static CHAR **utilList;            /* list of offline utilities            */

static INT exitcode=-1;            /* errorlevel for DOS                   */

static VOID setStdUtils(VOID);
static VOID getOthUtils(VOID);
static GBOOL isExit1Type(CHAR *chkItem);
static GBOOL isExit2Type(CHAR *chkItem);

INT
main(                              /* main routine                         */
INT argc,
CHAR *argv[])
{
     FILE *batfp;
     INT chosen;
     CHAR uname[9];

TRY

     (VOID)argc;
#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#else
     (VOID)argv;
#endif // GCWINNT
     initvid();
     if ((exitcode=setjmp(disaster)) != 0) {
          return(exitcode);
     }
     cvtscn(scntbl[0]);
     setStdUtils();
     getOthUtils();
#ifdef GCWINNT
     scblank(NULL,0x07);
#endif // GCWINNT
     scn2mem(savscn,0,GVIDSCNSIZ);
     explodeto(scntbl[0],0,0,67,15,5,4);
     nslatr=*(scntbl[0]+gvscnoff(2,3)+1);
     if ((chosen=choose(numUtils,utilList,2,3,65,12,1)) != -ESC) {
          memmove(uname,utilList[chosen],8);
          uname[8]='\0';
          if (isExit1Type(uname)) {
               exitcode=1;
          }
          else if (isExit2Type(uname)) {
               exitcode=2;
          }
          else if (sameto("WGSCLRAT",uname)) {
               exitcode=4;
          }
          else if (sameto("WGSRIDX",uname)) {
               exitcode=5;
          }
          else {
               exitcode=3;
          }
          if ((batfp=fopen("wgsutl.bat",FOPWA)) == NULL) {
               catastro("WGSUMENU: Unable to open \"wgsutl.bat\" for output!");
          }
          fprintf(batfp,"@echo off\n");
          fprintf(batfp,"%s\n",uname);
          fclose(batfp);
     }
     else {
          exitcode=0;
          mem2scn(savscn,0,GVIDSCNSIZ);
     }
     setatr(0x70);
     prat(4,15,"");
     cursiz(GVIDNOCURS);
     clsvid();
     return(exitcode);
EXCEPT
#ifdef GCWINNT
     return(100);
#endif // GCWINNT
}

static VOID
setStdUtils(VOID)                  /* preset standard Galacticomm utils    */
{
     INT i;

     utilList=(CHAR **)alczer(STDCNT*sizeof(CHAR *));
     for (i=0 ; i < STDCNT ; i++) {
          utilList[i]=alczer(sizeof(struct utils));
          strcpy(utilList[i],stdUtils[i].utlName);
          strcat(utilList[i]," -- ");
          strcat(utilList[i],stdUtils[i].utlDesc);
     }
     numUtils=STDCNT;
     maxIndex=numUtils-1;
}

static VOID
getOthUtils(VOID)                  /* read in additional utilities as need */
{
     FILE *reffp,*mdffp;
     CHAR mdfbuf[80],refbuf[40];

     if ((reffp=fopen("wgsutl.ref",FOPRA)) != NULL) {
          while (fscanf(reffp,"%12s\n",&refbuf) == 1) {
               if ((mdffp=fopen(refbuf,FOPRA)) == NULL) {
                    catastro("getOthUtils: Unable to open %s file",refbuf);
               }
               while (fgets(mdfbuf,sizeof(mdfbuf),mdffp) != NULL) {
                    if (sameto("Add-On Utility:",mdfbuf)) {
                         unpad(mdfbuf);
                         if (mdfbuf[15] != '\0') {
                              if (numUtils >= maxIndex) {
                                   utilList=(CHAR **)alcrsz(utilList,
                                        numUtils*sizeof(CHAR *),
                                        (numUtils+UTILINC)*sizeof(CHAR *));
                                   maxIndex+=UTILINC;
                              }
                              utilList[numUtils++]=alcdup(skpwht(mdfbuf+15));
                         }
                    }
               }
               fclose(mdffp);
          }
          fclose(reffp);
     }
}

static GBOOL                       /*   returns true if item is type 1     */
isExit1Type(                       /* is selected utility exit type 1?     */
CHAR *chkItem)                     /*   utility item to check for          */
{
     INT i;

     for (i=0 ; i < nelems(xit1List) ; i++) {
          if (sameto(chkItem,xit1List[i].utilName)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

static GBOOL                       /*   returns true if item is type 2     */
isExit2Type(                       /* is selected utility exit type 2?     */
CHAR *chkItem)                     /*   utility item to check for          */
{
     INT i;

     for (i=0 ; i < nelems(xit2List) ; i++) {
          if (sameto(chkItem,xit2List[i].utilName)) {
               return(TRUE);
          }
     }
     return(FALSE);
}

#if 0
/* The following exitcodes are generated when exiting this utility         */

errorlevel 0 - Escape pressed - no utility selected
errorlevel 1 = Remove Btrieve before running the utility
errorlevel 2 = Remove and reinstall Btrieve before running the utility
errorlevel 3 = Just run the utility
errorlevel 4 = Handle clearing of the Audit Trail data file
errorlevel 5 = Perform a complete system reindex
errorlevel 100 = Fault occured

#endif // if 0
