/***************************************************************************
 *                                                                         *
 *   WGSSWTCL.C                                                            *
 *                                                                         *
 *   Copyright (c) 1991-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the utility to switch all users in one class to another.      *
 *                                                                         *
 *                                                 - C. Robert 2/17/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "excphand.h"

#define FILREV "$Revision: 8 $"

static CHAR from[KEYSIZ];     /* switch users FROM *this* class            */
static CHAR to[KEYSIZ];       /* ...TO *this* class                        */
static INT days;              /* days left in this class (for TO class)    */
static CHAR dosscn[GVIDSCNSIZ];/* saved DOS screen image                   */

extern CHAR scntbl[][GVIDSCNSIZ];/* array of screens (c/o MAKESCNS)        */

static GBOOL validcls(INT c);
static VOID getdys(VOID),switchem(VOID),wrapup(VOID);

INT
main(                         /* main program loop                         */
INT argc,
CHAR *argv[])
{
TRY
     (VOID)argc;
#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#else
     (VOID)argv;
#endif // GCWINNT
     initvid();
     scn2mem(dosscn,0,GVIDSCNSIZ);
     cvtscn(scntbl[0]);
     explode(scntbl[0],17,11,62,22);
     cursiz(GVIDLILCURS);
     do {
          if (!edtval(42,16,KEYSIZ,from,validcls,ALLCAPS)) {
               wrapup();
               return(0);
          }
     } while (from[0] == '\0' && printf("\7"));
     locate(42,16);
     setatr(0x30);
     printf("%s",spr("%-*.*s",KEYSIZ-1,KEYSIZ-1,from));
     do {
          if (!edtval(42,17,KEYSIZ,to,validcls,ALLCAPS)) {
               wrapup();
               return(0);
          }
     } while (to[0] == '\0' && printf("\7"));
     locate(42,17);
     printf("%s",spr("%-*.*s",KEYSIZ-1,KEYSIZ-1,to));
     setatr(0x30);
     locate(19,20);
     printf("<Press any key to confirm, or ESC to exit>");
     cursiz(GVIDNOCURS);
     if (getchc() != ESC) {
          switchem();
          locate(45,20);
          printf("<Press any key>");
          getchc();
     }
     wrapup();
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}

static VOID
wrapup(VOID)                       /* wrap things up before exiting        */
{
     setatr(0x07);
     printf(" ");
     locate(0,24);
     mem2scn(dosscn,0,GVIDSCNSIZ);
     cursiz(GVIDLILCURS);
     clsvid();
}

static GBOOL
validcls(                          /* edtval() validation routine for class*/
INT c)
{
     return(((c <= 255 && isalnum(c)) || c == '_') ? TRUE : FALSE);
}

static VOID
switchem(VOID)                     /* go ahead and switch all users        */
{
     DFAFILE *uabb;
     INT upd=0,total=0;
     struct usracc acctmp;

     getdys();
     locate(20,20);
     printf("                                        ");
     uabb=dfaOpen("wgsusr2.dat",sizeof(struct usracc),NULL);
     locate(21,20);
     printf("Processing:");
     if (dfaQueryLO(0)) {
          do {
               dfaAbsRec(&acctmp,0);
               locate(33,20);
               printf("%s",spr("%-*.*s",UIDSIZ-1,UIDSIZ-1,acctmp.userid));
               if (sameas(acctmp.curcls,from)) {
                    upd=1;
                    strcpy(acctmp.curcls,to);
               }
               if (sameas(acctmp.prmcls,from)) {
                    upd=1;
                    strcpy(acctmp.prmcls,to);
                    acctmp.fgvdys=0;
                    acctmp.daystt=days;
               }
               if (upd) {
                    upd=0;
                    total++;
                    dfaUpdate(&acctmp);
               }
          } while (dfaQueryGT(acctmp.userid,0));
     }
     dfaClose(uabb);
     locate(19,20);
     printf("                                        ");
     locate(19,20);
     printf("%d user%c switched.",total,total == 1 ? '\0' : 's');
}

static VOID
getdys(VOID)                       /* get number of days left in TO class  */
{
     DFAFILE *clsbb;
     struct acclass tmpcls;

     days=1;
     clsbb=dfaOpen("wgsclas2.dat",sizeof(struct acclass),NULL);
     if (dfaAcqEQ(&tmpcls,to,0)) {
          if (tmpcls.flags&DAYEXP) {
               days=tmpcls.dftday;
          }
     }
     dfaClose(clsbb);
}
