/***************************************************************************
 *                                                                         *
 *   WGSSETCL.C                                                            *
 *                                                                         *
 *   Copyright (c) 1991-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the utility to set up the files WGSCLAS2.DAT and WGSKEY2.DAT  *
 *   for default accounting class set and keyring definitions.             *
 *                                                                         *
 *                                                 - C. Robert 2/17/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "excphand.h"

#define FILREV "$Revision: 12 $"

DFAFILE *keysbb,              /* BTRIEVE pointer to the WGSKEY2.DAT file   */
        *clsbb;               /* BTRIEVE pointer to the WGSCLAS2.DAT file  */

extern CHAR scntbl[][GVIDSCNSIZ];/* array of screens (c/o MAKESCNS)        */

static CHAR dosscn[GVIDSCNSIZ];  /* saved DOS screen image                 */
static INT oldguy=0;          /* the old system type the guy had selected  */
static GBOOL evrrun=FALSE;    /* was this ever run before?                 */

CHAR *tstcls[]={"DEMO","USER","PROSPECT","APPLICATION","DELETE_ACCOUNT"};

static VOID getold(VOID);
static VOID savcls(INT keep);
static VOID savstf(struct acclass *clsptr,INT keep);
static VOID uporin(struct acclass *clsptr);
static VOID svmsgs(INT keep);
static VOID savkys(VOID);
static VOID kinsert(CHAR *kysptr);

INT
main(                              /* main program loop                    */
INT argc,
CHAR *argv[])
{
TRY
     INT which;
     INT xlts[]={1,2,3,4,0};       /* choices below x-late to these #s     */
     INT xlts2[]={4,0,1,2,3};      /* (reverse translation)                */
     CHAR *chcs[]={
          " 1) public service      (PUBLIC MODEL)",
          " 2) support   (CUSTOMER-SERVICE MODEL)",
          " 3) restricted         (SIGN-UP MODEL)",
          " 4) members only       (PRIVATE MODEL)",
          " 5) pay for play    (FOR-PROFIT MODEL)",
     };
     DFAFILE *accbb;
     struct usracc tmpacc;

     (VOID)argc;
#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#else
     (VOID)argv;
#endif // GCWINNT
     initvid();
     scn2mem(dosscn,0,GVIDSCNSIZ);
     monorcol();
     cvtscn(scntbl[0]);
     keysbb=dfaOpen("wgskey2.dat",RINGSZ,NULL);
     clsbb=dfaOpen("wgsclas2.dat",sizeof(struct acclass),NULL);
     getold();
     explodeto(scntbl[0],17,13,62,24,17,10);
     cursiz(GVIDNOCURS);
     if (oldguy > 0) {
          setatr(0x30);
          locate(19,20);
          printf(" Use  and ENTER to select (ESC to quit). ");
          locate(20,12);
          printf("Your system is currently set to type #");
          setatr(0x3E);
          printf("%d",xlts2[oldguy-1]+1);
          setatr(0x30);
          printf(".");
     }
     selatr=0x70;
     nslatr=0x3E;
     proff(0,0);
     which=choose(5,chcs,20,14,58,18,evrrun);
     if (which != -ESC && !(oldguy && xlts[which] == oldguy-1)) {
          which=xlts[which];
          explodeto(scntbl[0],17,0,62,11,17,10);
          if (oldguy) {
               locate(32,19);
               setatr(0xBE);
               printf("(Changing type)");
          }
          else {
               accbb=dfaOpen("wgsusr2.dat",sizeof(struct usracc),NULL);
               stzcpy(tmpacc.userid,"Test",UIDSIZ);
               if (dfaAcqEQ(&tmpacc,tmpacc.userid,0)) {
                    stzcpy(tmpacc.curcls,tstcls[which],KEYSIZ);
                    stzcpy(tmpacc.prmcls,tstcls[which],KEYSIZ);
                    dfaUpdate(&tmpacc);
               }
               dfaClose(accbb);
               dfaSetBlk(clsbb);
          }
          savcls(which);
          savkys();
          svmsgs(which);
          setatr(0x30);
          locate(30,19);
          printf("<< Press any key >>");
          getchc();
     }
     dfaClose(clsbb);
     dfaClose(keysbb);
     setatr(0x07);
     printf(" ");
     locate(0,24);
     mem2scn(dosscn,0,GVIDSCNSIZ);
     cursiz(GVIDLILCURS);
     clsvid();
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}

static VOID
getold(VOID)                       /* get old system type from data file   */
{
     INT i=0;
     struct acclass tmpguy;
     static CHAR *clsset[]={"DEMO","USER","PROSPECT","APPLICATION","MEMBER"};

     if (dfaAcqLO(&tmpguy,0)) {
          evrrun=TRUE;
     }
     while (i < 5 && dfaAcqEQ(&tmpguy,clsset[i++],0)) {
          if (!(tmpguy.flags&HASCRD && tmpguy.flags&NOCRED)) {
               oldguy=i;
               break;
          }
     }
     if (oldguy == 2) {
          if (dfaAcqEQ(&tmpguy,"APPLICATION",0)) {
               if (!(tmpguy.flags&HASCRD && tmpguy.flags&NOCRED)) {
                    oldguy=4;
               }
          }
     }
}

static VOID
savcls(                            /* save the class sets to WGSCLAS2.DAT  */
INT keep)                          /* which set # to keep?                 */
{
     struct acclass *curguy;

     dfaSetBlk(clsbb);
     curguy=(struct acclass *)alcmem(sizeof(struct acclass));

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"DEMO");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"PROSPECT");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"APPLICATION");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"DELETE_ACCOUNT");
          break;
     }
     curguy->limcal=10;
     curguy->dftday=curguy->limday=-1;
     curguy->dbtlmt=0L;
     curguy->idlday=60;
     if (keep == 0) {
          curguy->flags|=(IDLEXP|HASCRD|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"PAYING");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"DEMO");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"CUSTOMER");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"MEMBER");
          break;
     }
     curguy->limcal=curguy->limday=curguy->dftday=-1;
     curguy->dbtlmt=0L;
     curguy->idlday=730;
     if (keep == 0) {
          curguy->flags|=(IDLEXP|NOCRED|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"MONTHLY");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[0],"PAYING");
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     strcpy(curguy->nxtcls[2],"PAYING");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"CUSTOMER");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"MEMBER");
          break;
     }
     curguy->limcal=-1;
     curguy->limday=180;
     curguy->dftday=30;
     curguy->dbtlmt=0L;
     curguy->idlday=730;
     if (keep == 0) {
          curguy->flags|=(IDLEXP|DAYEXP|CRDXMT|CLSCHG);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"WEEKLY");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[0],"PAYING");
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     strcpy(curguy->nxtcls[2],"PAYING");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"CUSTOMER");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"MEMBER");
          break;
     }
     curguy->limcal=-1;
     curguy->limday=180;
     curguy->dftday=7;
     curguy->dbtlmt=0L;
     curguy->idlday=730;
     if (keep == 0) {
          curguy->flags|=(IDLEXP|DAYEXP|CRDXMT|CLSCHG);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"BILLED");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"CUSTOMER");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"MEMBER");
          break;
     }
     curguy->limcal=curguy->limday=curguy->dftday=-1;
     curguy->dbtlmt=-1L;
     curguy->idlday=730;
     if (keep == 0) {
          curguy->flags|=(IDLEXP|FSTMTH|REPDBT|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"PROSPECT");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"DEMO");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"APPLICATION");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"DELETE_ACCOUNT");
          break;
     }
     curguy->limcal=30;
     curguy->limday=-1;
     curguy->dftday=-1;
     curguy->dbtlmt=-1L;
     curguy->idlday=60;
     if (keep == 2) {
          curguy->flags|=(CRDXMT|IDLEXP|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"CUSTOMER");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"MEMBER");
          break;
     }
     curguy->limcal=curguy->limday=-1;
     curguy->dftday=-1;
     curguy->dbtlmt=-1L;
     curguy->idlday=730;
     if (keep == 2) {
          curguy->flags|=(IDLEXP|CRDXMT|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"STAFF");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"SUPERVISOR");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"COORDINATOR");
          break;
     }
     curguy->limcal=curguy->limday=-1;
     curguy->dftday=-1;
     curguy->dbtlmt=-1L;
     curguy->idlday=9999;
     if (keep == 2) {
          curguy->flags|=(CRDXMT|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"APPLICATION");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"DEMO");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"PROSPECT");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"DELETE_ACCOUNT");
          break;
     }
     curguy->dftday=-1;
     curguy->dbtlmt=-1L;
     curguy->idlday=60;
     if (keep == 3) {
          curguy->flags|=(IDLEXP|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"USER");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"CUSTOMER");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"MEMBER");
          break;
     }
     curguy->limcal=curguy->limday=-1;
     curguy->dftday=-1;
     curguy->dbtlmt=-1L;
     curguy->idlday=730;
     if (keep == 1 || keep == 3) {
          curguy->flags|=(IDLEXP|CRDXMT|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"SUPERVISOR");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"STAFF");
          break;
     case 4:
          strcpy(curguy->nxtcls[3],"COORDINATOR");
          break;
     }
     curguy->limcal=curguy->limday=-1;
     curguy->dftday=-1;
     curguy->dbtlmt=-1L;
     curguy->idlday=9999;
     if (keep == 3) {
          curguy->flags|=(CRDXMT|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"MEMBER");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"CUSTOMER");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     }
     curguy->limcal=curguy->limday=-1;
     curguy->dftday=-1;
     curguy->dbtlmt=-1L;
     curguy->idlday=730;
     if (keep == 4) {
          curguy->flags|=(IDLEXP|CRDXMT|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"COORDINATOR");
     savstf(curguy,keep);
     strcpy(curguy->nxtcls[1],"DELETE_ACCOUNT");
     switch (keep) {
     case 0:
          strcpy(curguy->nxtcls[3],"PAYING");
          break;
     case 1:
          strcpy(curguy->nxtcls[3],"USER");
          break;
     case 2:
          strcpy(curguy->nxtcls[3],"STAFF");
          break;
     case 3:
          strcpy(curguy->nxtcls[3],"SUPERVISOR");
          break;
     }
     curguy->limcal=curguy->limday=-1;
     curguy->dftday=-1;
     curguy->dbtlmt=-1L;
     curguy->idlday=9999;
     if (keep == 4) {
          curguy->flags|=(CRDXMT|KCKOFF);
     }
     else {
          curguy->flags|=(HASCRD|NOCRED);
     }
     uporin(curguy);

     setmem(curguy,sizeof(struct acclass),0);
     strcpy(curguy->clname,"SYSOP");
     savstf(curguy,keep);
     curguy->limcal=curguy->limday=curguy->dftday=-1;
     curguy->flags|=(CRDXMT|KCKOFF);
     curguy->dbtlmt=-1L;
     curguy->idlday=9999;
     if (!dfaQueryEQ("SYSOP",0)) {
          dfaInsert(curguy);
     }
}

static VOID
savstf(                            /* save some things from the old record */
struct acclass *clsptr,            /* pointer to class to fill in          */
INT keep)                          /* which class set is being kept?       */
{
     static struct acclass tmpcls;

     dfaSetBlk(clsbb);
     if (dfaAcqEQ(&tmpcls,clsptr->clname,0)) {
          clsptr->seconds=tmpcls.seconds;
          clsptr->users=tmpcls.users;
     }
     else if (oldguy == 0) {
          if (sameas(clsptr->clname,"SYSOP")
              || sameas(clsptr->clname,tstcls[keep])) {
               clsptr->users=1;
          }
     }
     dfaRstBlk();
}

static VOID
uporin(                            /* update or insert a class record      */
struct acclass *clsptr)            /* pointer to record to update/ins      */
{
     if (dfaAcqEQ(NULL,clsptr->clname,0)) {
          dfaUpdate(clsptr);
     }
     else {
          dfaInsert(clsptr);
     }
}

static VOID
svmsgs(                            /* save all the message options         */
INT keep)                          /* which set # to keep?                 */
{
     CHAR supcls[KEYSIZ],shwcrd[KEYSIZ],sampln[KEYSIZ];

     switch (keep) {
     case 0:
          strcpy(supcls,"DEMO");
          strcpy(shwcrd,"YES");
          strcpy(sampln,"256");
          break;
     case 1:
          strcpy(supcls,"USER");
          strcpy(shwcrd,"NO");
          strcpy(sampln,"256");
          break;
     case 2:
          strcpy(supcls,"PROSPECT");
          strcpy(shwcrd,"NO");
          strcpy(sampln,"256");
          break;
     case 3:
          strcpy(supcls,"APPLICATION");
          strcpy(shwcrd,"NO");
          strcpy(sampln,"256");
          break;
     case 4:
          strcpy(supcls,"MEMBER");
          strcpy(shwcrd,"NO");
          strcpy(sampln,"0");
          break;
     }
     setcnf("SUPCLS",supcls);
     setcnf("SHWCRD",shwcrd);
     applyem("wgssup.msg");
     setcnf("SAMPLN",sampln);
     applyem("wgsmajor.msg");
}

static VOID
savkys(VOID)                       /* save keyring records to WGSKEY2.DAT  */
{
     CHAR holding[RINGSZ];

     dfaSetBlk(keysbb);
     setmem(holding,RINGSZ,0);
     strcpy(&holding[KLSTOF],"DEMO");
     stzcpy(holding,"&DEMO",30);
     kinsert(holding);
     stzcpy(holding,"&PROSPECT",30);
     kinsert(holding);
     stzcpy(holding,"&APPLICATION",30);
     kinsert(holding);

     setmem(holding,RINGSZ,0);
     strcpy(&holding[KLSTOF],"DEMO NORMAL MODERATE");
     stzcpy(holding,"&PAYING",30);
     kinsert(holding);
     stzcpy(holding,"&MONTHLY",30);
     kinsert(holding);
     stzcpy(holding,"&WEEKLY",30);
     kinsert(holding);
     stzcpy(holding,"&BILLED",30);
     kinsert(holding);

     setmem(holding,RINGSZ,0);
     strcpy(&holding[KLSTOF],"DEMO NORMAL");
     stzcpy(holding,"&USER",30);
     kinsert(holding);
     stzcpy(holding,"&CUSTOMER",30);
     kinsert(holding);
     stzcpy(holding,"&MEMBER",30);
     kinsert(holding);

     setmem(holding,RINGSZ,0);
     strcpy(&holding[KLSTOF],"DEMO NORMAL MODERATE MASS_MAILING SUPER");
     stzcpy(holding,"&STAFF",30);
     kinsert(holding);
     stzcpy(holding,"&SUPERVISOR",30);
     kinsert(holding);
     stzcpy(holding,"&COORDINATOR",30);
     kinsert(holding);

     if (!dfaQueryEQ("&SYSOP",0)) {
          setmem(holding,RINGSZ,0);
          strcpy(&holding[KLSTOF],
                 "DEMO NORMAL MODERATE MASS_MAILING SUPER SYSOP");
          stzcpy(holding,"&SYSOP",30);
          dfaInsertV((struct keyrec *)holding,KLSTOF+strlen(&holding[KLSTOF])+1);
     }
}

static VOID
kinsert(                           /* insert a keyring record (if needed)  */
CHAR *kysptr)                      /* pointer to record to update/ins      */
{
     if (!dfaQueryEQ(kysptr,0)) {
          dfaInsertV((struct keyrec *)kysptr,KLSTOF+strlen(&kysptr[KLSTOF])+1);
     }
}
