/***************************************************************************
 *                                                                         *
 *   WGSRUNWZ.C                                                            *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.    *
 *                                                                         *
 *   Offline utility to run the Setup Wizard under NT.                     *
 *                                                                         *
 *                                        - Joe Delekto 10/01/96           *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "excphand.h"
#include "runapp.h"

#define FILREV "$Revision: 5 $"

INT WINAPI
WinMain(
HINSTANCE hInstance,               // handle to current instance
HINSTANCE hPrevInstance,           // handle to previous instance
LPSTR lpCmdLine,                   // pointer to command line
INT nCmdShow)                      // show state of window
{
TRY
     CHAR *pTmp;
     CHAR path[2048];
     INT retVal;

     (VOID)hPrevInstance;
     (VOID)lpCmdLine;
     (VOID)nCmdShow;
     GetModuleFileName(hInstance,path,sizeof(path));
     if (!canRunGroup()) {
          MessageBox(NULL,NOPROCEED,
                    path,MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
     if ((pTmp=strrchr(path,'\\')) != NULL
          || (pTmp=strrchr(path,'/')) != NULL) {
          *pTmp='\0';
          chdir(path);
          *pTmp='\\';
     }
     if (!(isfile("wgsusr2.dat")        /* if the names of these files     */
        && isfile("wgsclas2.dat")       /* change, this statement must be  */
        && isfile("wgskey2.dat"))) {    /* changed as well                 */
          if (!runApp("wgsint",NULL,SW_SHOWDEFAULT,&retVal)) {
               MessageBox(NULL,"WGSRUNWZ: Unable to execute WGSINT!",path,
                          MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
               return(1);
          }
     }
     else {
          if (!runApp("wgsswzd",NULL,SW_SHOWDEFAULT,&retVal)) {
               MessageBox(NULL,"WGSRUNWZ: Unable to execute Setup Wizard!",path,
                          MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
               return(1);
          }
     }
     return(0);
EXCEPT
     return(1);
}
