/***************************************************************************
 *                                                                         *
 *   RUNAPP.C                                                              *
 *                                                                         *
 *   Copyright (c) 1992-1997 Galacticomm, Inc.    All rights reserved.     *
 *                                                                         *
 *   Utility function to initiate a processs based on the passed command   *
 *   line.  This is very specific for NT utilities that simulate WGSINTRO. *
 *                                                                         *
 *                                    - Richard Skurnick  05/31/96         *
 *                                                                         *
 ***************************************************************************/

#include <windows.h>
#include "gcomm.h"
#include "runapp.h"

#define FILREV "$Revision: 11 $"

GBOOL                              //   return TRUE-Ok
runApp(                            // runs application
const CHAR *pCmdLine,              //   command line
CHAR *lpTitle,                     //   window caption
INT showFlag,                      //   window show flag SW_XXX
INT *retVal)                       //   exit code from process
{
     STARTUPINFO startInfo;
     PROCESS_INFORMATION procInfo;
     DWORD exitCode;

     *retVal=0;
     memset(&startInfo,0,sizeof(STARTUPINFO));
     startInfo.cb=sizeof(STARTUPINFO);
     startInfo.lpTitle=lpTitle;
     startInfo.dwFlags=STARTF_USESHOWWINDOW;
     startInfo.wShowWindow=(WORD)showFlag;
     if (!CreateProcess(NULL,                // programm name
                        (LPTSTR)pCmdLine,    // command line string
                        NULL,                // process security attributes
                        NULL,                // thread security attributes
                        TRUE,                // handle inheritance flag
                        CREATE_DEFAULT_ERROR_MODE, // creation flags
                        NULL,                // new environment block
                        NULL,                // current directory name
                        &startInfo,          // STARTUPINFO
                        &procInfo)) {        // PROCESS_INFORMATION
          return(FALSE);
     }
     WaitForSingleObject(procInfo.hProcess,INFINITE);
     GetExitCodeProcess(procInfo.hProcess,&exitCode);
     CloseHandle(procInfo.hProcess);
     CloseHandle(procInfo.hThread);
     *retVal=(INT)exitCode;
     return(TRUE);
}
