/***************************************************************************
 *                                                                         *
 *  WGSMREF.C                                                              *
 *                                                                         *
 *  Copyright (c) 1993-1997 Galacticomm, Inc.        All Rights Reserved.  *
 *                                                                         *
 *  Modem setup information look-up utility.                               *
 *                                                                         *
 *                                                - B. Stephens    8/4/93  *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "brkthu.h"

#define FILREV "$Revision: 5 $"

#define RECLEN      80             /* Max record length in WGSSETUP.LST    */
#define MODLEN      41             /* Modem description length +1 for NUL  */
#define INILEN      45             /* Ini string length +1 for NUL         */
#define BAULEN      6              /* Baud rate length +1 for NUL          */
#define LOKLEN      4              /* Lock port length +1 for NUL          */

#define YELGRN      0x2E           /* Bright yellow on green               */

VOID genini(VOID);
VOID getmod(INT idx);
VOID getini(INT idx);
VOID getbau(INT idx);
VOID getlok(INT idx);
VOID getblk(VOID);

CHAR *scn1,*scn2;                  /* pointers to saved screens            */
extern CHAR scntbl[1][GVIDSCNSIZ]; /* table of screens                     */
FILE *fp;                          /* file pointer for WGSSETUP.LST        */
INT maxnum;                        /* total # of entries in WGSSETUP.LST   */
CHAR *mlist,*ilist,*blist,         /* pointers to modem info               */
     *llist,**mptrs;
INT aborted=0;                     /* user "aborted" flag                  */
INT curnum=0;                      /* currently selected modem list entry  */

VOID                               /* WGSETUP mainline code                */
main(VOID)
{
     INT c;

     genini();
     while (!aborted) {
          supchc(maxnum,mptrs,2,1,41,9,TRUE);
          dspchc();
          cursiz(GVIDNOCURS);
          do {
               c=getchc();
               if (c == F1) {
                    scn2mem(scn2,0,GVIDSCNSIZ);
                    explodeto(scntbl[1],0,0,66,14,6,4);
                    getchc();
                    mem2scn(scn2,0,GVIDSCNSIZ);
               }
               curnum=hdlchc(c);
          } while (curnum == maxnum);
          rstcur();
          if (curnum != -ESC) {
               scn2mem(scn2,0,GVIDSCNSIZ);
               explodeto(scntbl[0],0,14,53,22,11,8);
               setatr(YELGRN);
               prat(8,2,"%s",&mlist[curnum*MODLEN]);
               prat(8,4,"%s",&blist[curnum*BAULEN]);
               prat(8,5,"%s",&llist[curnum*LOKLEN]);
               prat(8,6,"%s",&ilist[curnum*INILEN]);
               c=getchc();
               if (c != ESC) {
                    mem2scn(scn2,0,GVIDSCNSIZ);
                    proff(16,5);
               }
               else {
                    aborted=1;
               }
          }
          else {
               aborted=1;
          }
     }
     setatr(0x07);

     printf(" ");
     locate(0,24);
     mem2scn(scn1,0,GVIDSCNSIZ);
     cursiz(GVIDLILCURS);
     clsvid();
     exit(0);
}

VOID                               /* General WGSMREF initialization       */
genini(VOID)
{
     INT i,c;
     CHAR tmp[RECLEN];

     initvid();
     cursiz(GVIDNOCURS);
     monorcol();
     scn1=alcmem(GVIDSCNSIZ);
     scn2=alcmem(GVIDSCNSIZ);
     scn2mem(scn1,0,GVIDSCNSIZ);
     explodeto(scntbl[0],44,0,79,13,20,5);
     if ((c=getchc()) == ESC || c == ALT_X || c == F10) {
          aborted=1;
          return;
     }
     mem2scn(scn1,0,GVIDSCNSIZ);

     if ((fp=fopen("wgssetup.lst",FOPRA)) == NULL) {
          catastro("WGSMREF: COULDN'T OPEN WGSSETUP.LST!");
     }
     maxnum=0;
     while (fgets(tmp,RECLEN,fp) != NULL) {
          maxnum++;
     }
     maxnum=maxnum/8;
     mlist=alczer(maxnum*MODLEN);
     ilist=alczer(maxnum*INILEN);
     blist=alczer(maxnum*BAULEN);
     llist=alczer(maxnum*LOKLEN);
     mptrs=(CHAR **)alczer((maxnum+1)*sizeof(CHAR *));
     for (i=0 ; i < maxnum ; i++) {
          mptrs[i]=&mlist[i*MODLEN];
     }
     mptrs[maxnum]=NULL;
     rewind(fp);
     for (i=0 ; i < maxnum ; i++) {
          getmod(i);
          getbau(i);
          getlok(i);
          getini(i);
          getblk();
          getblk();
          getblk();
          getblk();
     }
     fclose(fp);
     scn2mem(scn1,0,GVIDSCNSIZ);
     explodeto(scntbl[0],0,0,43,13,16,5);
}

VOID                               /* get modem name from WGSSETUP.LST     */
getmod(INT idx)
{
     INT i,len;
     CHAR tmp[RECLEN];

     fgets(tmp,RECLEN,fp);
     len=strlen(tmp)-1;                           /* remove <CR>           */
     for (i=0 ; i < len ; i++) {                  /* change '_' to spaces  */
          tmp[i]=(tmp[i] == '_') ? ' ' : tmp[i];
     }
     for (i=len ; i < MODLEN ; i++) {             /* pad with spaces       */
          tmp[i]=' ';
     }
     tmp[MODLEN-1]='\0';
     strcpy(&mlist[idx*MODLEN],tmp);
}

VOID                               /* get init string from WGSSETUP.LST    */
getini(INT idx)
{
     INT i,len;
     CHAR tmp[RECLEN];

     fgets(tmp,RECLEN,fp);
     len=strlen(tmp)-1;
     for (i=len ; i < INILEN ; i++) {             /* pad with spaces       */
          tmp[i]=' ';
     }
     tmp[INILEN-1]='\0';
     strcpy(&ilist[idx*INILEN],tmp);
}

VOID                               /* get baud rate from WGSSETUP.LST      */
getbau(INT idx)
{
     INT i,len;
     CHAR tmp[RECLEN];

     fgets(tmp,RECLEN,fp);
     len=strlen(tmp)-1;
     for (i=len ; i < BAULEN ; i++) {             /* pad with spaces       */
          tmp[i]=' ';
     }
     tmp[BAULEN-1]='\0';
     strcpy(&blist[idx*BAULEN],tmp);
}

VOID                               /* get lock info from WGSSETUP.LST      */
getlok(INT idx)
{
     INT i,len;
     CHAR tmp[RECLEN];

     fgets(tmp,RECLEN,fp);
     len=strlen(tmp)-1;
     for (i=len ; i < LOKLEN ; i++) {             /* pad with spaces       */
          tmp[i]=' ';
     }
     tmp[LOKLEN-1]='\0';
     strcpy(&llist[idx*LOKLEN],tmp);
}

VOID                               /* get blank line from WGSSETUP.LST     */
getblk(VOID)
{
     CHAR tmp[RECLEN];

     fgets(tmp,RECLEN,fp);
}
