/***************************************************************************
 *                                                                         *
 *   WGSCOLOR.C                                                            *
 *                                                                         *
 *   Copyright (c) 1991-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the utility to change all of one ANSI attribute or color      *
 *   into another (in all .MSG files).  The user will also be given        *
 *   the option of switching two colors with one another.                  *
 *                                                                         *
 *                                                 - C. Robert 3/11/92     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "excphand.h"

#define FILREV "$Revision: 7 $"

extern CHAR scntbl[][GVIDSCNSIZ];/* table of pre-OBJ'd screen files*/

CHAR dosscn[GVIDSCNSIZ];           /* save-screen buffer for old DOS screen*/

static INT swap=0;            /* do we want to swap two ANSI codes? 1 or 0 */
static INT from,to;           /* change what ANSI code -> what other one?  */
static CHAR buffer[512];      /* buffer for reading in .MSG file lines     */

static INT chklin(VOID);
static VOID gotone(VOID),chgthm(VOID),newmsg(CHAR *filnam);

INT
main(                              /* main program entry point             */
INT argc,
CHAR *argv[])
{
TRY
     CHAR *chcs1[]={
          "Change one color into another",
          "Swap occurences of two colors"
     };
     CHAR *chcs2[]={
          "Normal display attribute",
          "Bold display attribute",
          "Underscore display attribute",
          "Blink display attribute",
          "Reverse display attribute",
          "Invisible display attribute",
          "Black foreground",
          "Red foreground",
          "Green foreground",
          "Yellow foreground",
          "Blue foreground",
          "Magenta foreground",
          "Cyan foreground",
          "White foreground",
          "Black background",
          "Red background",
          "Green background",
          "Yellow background",
          "Blue background",
          "Magenta background",
          "Cyan background",
          "White background"
     };
     CHAR *chcs3[]={
          "Normal display attribute",
          "Bold display attribute",
          "Underscore display attribute",
          "Blink display attribute",
          "Reverse display attribute",
          "Invisible display attribute"
     };
     CHAR *chcs4[]={
          "Black foreground",
          "Red foreground",
          "Green foreground",
          "Yellow foreground",
          "Blue foreground",
          "Magenta foreground",
          "Cyan foreground",
          "White foreground"
     };
     CHAR *chcs5[]={
          "Black background",
          "Red background",
          "Green background",
          "Yellow background",
          "Blue background",
          "Magenta background",
          "Cyan background",
          "White background"
     };
     INT retval;
     INT xlttbl[]={0,1,4,5,7,8,30,31,32,33,34,35,36,37,40,41,42,43,44,45,46,47};

     (VOID)argc;
#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#else
     (VOID)argv;
#endif // GCWINNT
     initvid();
     scn2mem(dosscn,0,GVIDSCNSIZ);
     monorcol();
     cvtscn(scntbl[0]);
     cvtscn(scntbl[1]);
     explodeto(scntbl[0],13,5,66,20,14,8);
     cursiz(GVIDNOCURS);
     proff(0,0);
     selatr=0x7E;
     nslatr=0x3E;
     if ((swap=choose(2,chcs1,27,20,55,21,TRUE)) != -ESC) {
          explode(scntbl[1],5,0,35,24);
          proff(0,0);
          selatr=0x70;
          nslatr=0x20;
          if (swap) {
               setatr(0x70);
               locate(20,0);
               printf("switch");
          }
          if ((from=choose(22,chcs2,6,2,33,23,TRUE)) != -ESC) {
               explodeto(scntbl[1],45,0,74,10,25,6);
               proff(0,0);
               if (swap) {
                    setatr(0x70);
                    locate(40,6);
                    printf("switch with: ");
               }
               if (from < 6) {
                    retval=choose(6,chcs3,26,8,53,15,TRUE);
               }
               else if (from < 14) {
                    retval=choose(8,chcs4,26,8,53,15,TRUE);
               }
               else {
                    retval=choose(8,chcs5,26,8,53,15,TRUE);
               }
               if (retval != -ESC) {
                    from=xlttbl[from];
                    if (from >= 30) {
                         if (from < 40) {
                              retval+=6;
                         }
                         else {
                              retval+=14;
                         }
                    }
                    to=xlttbl[retval];
                    explodeto(scntbl[1],45,18,74,24,41,13);
                    proff(0,0);
                    chgthm();
                    locate(46,19);
                    setatr(0x2E);
                    printf("(");
                    setatr(0xAE);
                    printf("DONE!");
                    setatr(0x2E);
                    printf(" Hit any key.)");
                    getchc();
               }
          }
     }
     setatr(0x07);
     printf(" ");
     locate(0,24);
     mem2scn(dosscn,0,GVIDSCNSIZ);
     cursiz(GVIDLILCURS);
     clsvid();
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}

static VOID
chgthm(VOID)                       /* go ahead and go through .MSG files   */
{
     FILE *fp;
     LONG bgnlin,endlin;
     struct filblklst filblk;

     if (fil1stlst(&filblk,"","*.msg")) {
          do {
               if ((fp=fopen(filblk.fb.ff_name,FOPRWA)) != NULL) {
                    newmsg(filblk.fb.ff_name);
                    bgnlin=ftell(fp);
#ifdef UNIX
                    while (fgets(buffer,512,fp) != NULL) {
#else
                    while (mdfgets(buffer,512,fp) != NULL) {
#endif
                         if (chklin()) {
                              endlin=ftell(fp);
                              fseek(fp,bgnlin,SEEK_SET);
                              fprintf(fp,"%s",buffer);
                              fseek(fp,bgnlin=endlin,SEEK_SET);
                         }
                         else {
                              bgnlin=ftell(fp);
                         }
                    }
                    fclose(fp);
               }
          } while (filnxtlst(&filblk));
     }
}

static INT
chklin(VOID)                       /* check the current line for a match   */
{
     INT retval=0,val;
     CHAR *bas,*ptr,savchr;

     ptr=buffer;
     while (*ptr != '\0') {
          if (*ptr++ == 27 && *ptr++ == '[') {
               bas=ptr;
               while (!isalpha(*ptr)) {
                    ptr++;
               }
               if (*ptr == 'm') {
                    ptr=bas;
                    do {
                         if (*ptr == ';' || isalpha(*ptr)) {
                              savchr=*ptr;
                              *ptr='\0';
                              if (isdigit(*bas)) {
                                   if ((val=atoi(bas)) == from) {
                                        strcpy(bas,spr("%d",to));
                                        gotone();
                                        retval=1;
                                   }
                                   else if (swap && (val == to)) {
                                        strcpy(bas,spr("%d",from));
                                        gotone();
                                        retval=1;
                                   }
                              }
                              *ptr=savchr;
                              bas=ptr+1;
                         }
                         else if (*ptr == '\0') {
                              return(retval);
                         }
                    } while (!isalpha(*ptr++));
               }
          }
     }
     return(retval);
}

static VOID
gotone(VOID)                       /* changed one more color or attribute  */
{
     static INT sofar=0;

     sofar++;
     setatr(0x2E);
     locate(63,17);
     printf("%5d",sofar);
}

static VOID
newmsg(                            /* going to a new message file now...   */
CHAR *filnam)                      /* new message file name to display     */
{
     setatr(0x2E);
     locate(55,15);
     printf("%13s",filnam);
}
