/***************************************************************************
 *                                                                         *
 *   WGSAREF.C                                                             *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the utility to show the Sysop what App-IDs go with what       *
 *   modules.                                                              *
 *                                                                         *
 *                                                 - C. Robert 1/28/96     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "gcspsrv.h"
#include "excphand.h"

#define FILREV "$Revision: 6 $"

extern CHAR scntbl[][GVIDSCNSIZ];  /* array of screens (c/o MAKESCNS)      */

static CHAR dosscn[GVIDSCNSIZ];    /* saved DOS screen image               */

INT
main(
INT argc,
CHAR *argv[])
{
TRY
     FILE *lstfp;
     INT nmdfs,numapps,slen;
     CHAR **apps;
     CHAR linbuf[BUFSIZ];
     GBOOL wasapp;
     CHAR modnam[MNMSIZ],appid[AIDSIZ],*ptr;

     (VOID)argc;
#ifdef GCWINNT
     if (!canRunUtil()) {
          MessageBox(NULL,NOPROCEED,
                    argv[0],MB_ICONSTOP|MB_OK|MB_TASKMODAL|MB_SETFOREGROUND);
          return(1);
     }
#else
     (VOID)argv;
#endif // GCWINNT
     initvid();
     scn2mem(dosscn,0,GVIDSCNSIZ);
     monorcol();
     cvtscn(scntbl[0]);
     explode(scntbl[0],17,5,62,17);
     proff(0,0);
     cursiz(GVIDNOCURS);
     if ((lstfp=fopen("wgsmdfs.lst",FOPRA)) == NULL) {
          catastro("WGSAREF: can't open wgsmdfs.lst!");
     }
     if (fgets(linbuf,BUFSIZ,lstfp) == NULL || (nmdfs=atoi(linbuf)) < 1) {
          catastro("WGSAREF: wgsmdfs.lst is corrupt!");
     }
     apps=(CHAR **)alcmem(nmdfs*sizeof(CHAR *));
     numapps=0;
     while (fgets(linbuf,BUFSIZ,lstfp) != NULL && nmdfs-- > 0) {
          if ((slen=strlen(linbuf)) == 0) {
               break;
          }
          linbuf[slen-1]='\0';
          if (tfsopn(linbuf) == 1) {
               wasapp=FALSE;
               modnam[0]='\0';
               while (tfsrdl() != TFSDUN) {
                    if (tfstate == TFSLIN) {
                         if (tfspfx("Client app EXE:")) {
                              wasapp=TRUE;
                         }
                         else if (tfspfx("Module Name:")) {
                              stlcpy(modnam,tfspst,MNMSIZ);
                         }
                    }
               }
               if (wasapp) {
                    stlcpy(appid,linbuf,AIDSIZ);
                    if ((ptr=strchr(appid,'.')) != NULL) {
                         *ptr='\0';
                    }
                    strupr(appid);
                    apps[numapps++]=strdup(spr("%-25s   %s",modnam,appid));
               }
          }
     }
     fclose(lstfp);
     selatr=0x70;
     nslatr=0x3E;
     while (choose(numapps,apps,22,13,57,15,1) != -ESC) {
     }
     setatr(0x07);
     printf(" ");
     locate(0,24);
     mem2scn(dosscn,0,GVIDSCNSIZ);
     cursiz(GVIDLILCURS);
     return(0);
EXCEPT
#ifdef GCWINNT
     return(1);
#endif // GCWINNT
}
