#############################################################################
##  Sun/Microsoft Java compiler options                                    ##
#############################################################################
!if !$d(JAVA10)
!    error JAVA10 environment variable not set!
!endif
!if !$d(SRCDIR)
!    message To proper make ZIP & CAB files, you must specify the SRCDIR macro.
!endif


#############################################################################
##  Required variables for the make procedure                              ##
#############################################################################
JAVACC   = $(JAVA10)\bin\javac -O -depend -d $(TEMPDIR)
RUNDIR   = $(WGNT)
COMPILER = $(CC)

#############################################################################
##  Required implicit definition for JAVA makes                            ##
#############################################################################
.path.zip = $(RUNDIR)\webpages\classes
.path.cab = $(RUNDIR)\webpages\classes
.path.jar = $(RUNDIR)\webpages\classes
.path.class = $(TEMPDIR)

.java.class:
     $(JAVACC) $<

.class.zip:
     galmkdir $(JAVADIR)
     if exist $@ del $@
     cd $(TEMPDIR)
     zip -0 -r $@ $(CLASSFILES) *.class com
     cd $(SRCDIR)

.class.jar:
     galmkdir $(JAVADIR)
     if exist $@ del $@
     cd $(TEMPDIR)
     zip -9 -r $@ $(CLASSFILES) *.class com
     cd $(SRCDIR)

.class.cab:
     galmkdir $(JAVADIR)
     cd $(TEMPDIR)
     cabarc -p -r n $@ $(CLASSFILES) *.class
     cd $(SRCDIR)
