/***************************************************************************
 *                                                                         *
 *   SUBSTI.C                                                              *
 *                                                                         *
 *   Copyright (C) 1996-1997 Galacticomm, Inc.   All rights reserved.      *
 *                                                                         *
 *   File text-substitution routine.                                       *
 *                                                                         *
 *                                                - T. Stryker 1/30/96     *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"

#define FILREV "$Revision: 5 $"

#define CHGSIZ   80                /* maximum bytes per old/new zstring    */

CHAR *                             /*   return error message or NULL       */
substi(                            /* substitute new zstgs for old in file */
CHAR *filein,                      /*   filespec of input file             */
CHAR *fileout,                     /*   filespec of output file            */
INT  nchgs,                        /*   number of old/new strings          */
CHAR *tobechgd[],                  /*   array of zstrings to be changed    */
CHAR *chgemto[])                   /*   array of zstrings to change 'em to */
{
     FILE *ifp,*ofp;
     INT i,j,c,endfile;
     static CHAR cbuf[256];

     if ((ifp=fopen(filein,FOPRB)) == NULL) {
          sprintf(cbuf,"Can't open \"%s\" for input!",filein);
          return(cbuf);
     }
     if ((ofp=fopen(fileout,FOPWB)) == NULL) {
          fclose(ifp);
          sprintf(cbuf,"Can't open \"%s\" for output!",fileout);
          return(cbuf);
     }
     endfile=0;
     for (i=0 ; i < CHGSIZ ; i++) {
          if ((c=fgetc(ifp)) == EOF) {
               endfile+=1;
          }
          cbuf[i]=c;
     }
     while (endfile < CHGSIZ) {
          for (i=0 ; i < nchgs ; i++) {
               if (memicmp(cbuf,tobechgd[i],strlen(tobechgd[i])) == 0) {
                    for (j=0 ; j < strlen(chgemto[i]) ; j++) {
                         fputc(chgemto[i][j],ofp);
                    }
                    for (j=0 ; j < strlen(tobechgd[i]) ; j++) {
                         memmove(cbuf,cbuf+1,CHGSIZ-1);
                         if ((c=fgetc(ifp)) == EOF) {
                              endfile++;
                         }
                         cbuf[CHGSIZ-1]=c;
                    }
                    break;
               }
          }
          if (i == nchgs) {
               fputc(cbuf[0],ofp);
               memmove(cbuf,cbuf+1,CHGSIZ-1);
               if ((c=fgetc(ifp)) == EOF) {
                    endfile++;
               }
               cbuf[CHGSIZ-1]=c;
          }
     }
     fclose(ifp);
     fclose(ofp);
     return(NULL);
}

