/***************************************************************************
 *                                                                         *
 *   WGSTVAR.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Worldgroup implementation of Text Variables, derived from             *
 *   tvbDefinition class.                                                  *
 *                                                                         *
 *                                              - R. Stein  8/17/96        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "tvb.h"

#define FILREV "$Revision: 2 $"

#if TVBNAMSIZ < TVRSIZ
#error TVBNAMSIZ < TVRSIZ          // correlation with TVRSIZ in majorbbs.h
#endif

class wgsDefinition : public tvbDefinition {

public:
     wgsDefinition();

     GBOOL                         //   TRUE=this definition can resolve
     claim(                        // does this definition claim this name?
     const CHAR *nam);             //   name of text variable

     const CHAR *                  //   it gives you a value ("" if !claim())
     resolve(                      // resolve a text var name into its value
     const CHAR *nam);             //   give it the name of the text variable
                                   //   Returned string lives at least until
                                   //   same def instance is resolve()'d again.
};

wgsDefinition wgsTvars;            // contains all register_textvar()'s

wgsDefinition::wgsDefinition()     // construct Worldgroup text var definer
{
     registerDef();
}

GBOOL                              //   TRUE=this definition can resolve
wgsDefinition::claim(              // does this definition claim this name?
const CHAR *nam)                   //   name of text variable
{
     return(findtvar(const_cast<CHAR *>(nam)) != -1);
}

const CHAR *                       //   it gives you a value ("" if !claim())
wgsDefinition::resolve(            // resolve a text var name into its value
const CHAR *nam)                   //   give it the name of the text variable
                                   //   Returned string lives at least until
{                                  //   same def instance is resolve()'d again.
     INT idx=findtvar(const_cast<CHAR *>(nam));
     if (idx == -1) {
          return("");
     }
     else {
          return((*(txtvars[idx].varrou))());
     }
}

