/***************************************************************************
 *                                                                         *
 *   SOCKLST.H                                                             *
 *                                                                         *
 *   Copyright (c) 1994-1998 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is the header file for the dynamic socket list API               *
 *   used by the modified Windows 95/NT TCP/IP Kernel.                     *
 *                                                                         *
 *   Initial implementation.            - W. Muharsky                      *
 *                                      - J. Delekto       1/7/1997        *
 ***************************************************************************/

#ifndef __SOCKLST_H
#define __SOCKLST_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

VOID
slShutdown(VOID);                  /* Cleanup socket list                  */

VOID
slTrack(                           /* Add or update socket events          */
INT iSocket,                       /*   Socket number to track             */
LONG lEvent);                      /*   Event flags we are interested in   */

VOID
slUntrack(                         /* Clear certain socket events          */
INT iSocket,                       /*   Socket number to untrack           */
LONG lEvent);                      /*   Event flags to clear               */

LONG                               /*   Returned flags for the socket      */
slEvents(                          /* Retrieve the flags for a socket      */
INT iSocket);                      /*   Socket we want the flags for       */

VOID
slRemove(                          /* Remove a socket from the track list  */
INT iSocket);                      /*   Socket number to remove            */

VOID
UpdateRecalls(VOID);               /*  Update 2 recall events being tracked */

VOID
RecallAdd(                         /*  Add a Recall Event                  */
INT iEvent,                        /*  Event to add for                    */
INT iSocket);                      /*  Socket number to add to list        */

VOID
HandleSocket(                      /* Handle a socket from the list        */
LONG lEvent,                       /*   Event flags to look for            */
INT iSocket);                      /*   Socket to handle                   */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __SOCKLST_H
