/* GALHPAC.H - stuff needed between TCPIP.C and GALHPAC.C */

#ifndef __GALHPAC_H
#define __GALHPAC_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

extern
int shuttmo;                       /* config option from TCPIP.C           */

extern
int sockmem;                       /* heap memory needed per socket 4 data */

extern
int pacintsvc;                     /* interrupt now being serviced         */

extern
unsigned                           /*   number of bytes actually output    */
(*slppp_out_handler)(              /* vector to SLIP/PPP output handler    */
     char *ptr,                    /*   pointer to bytes to go out         */
     unsigned nbytes);             /*   number of bytes to go out          */

int                                /*   0=ok, otherwise=error code         */
slppp_in_handler(                  /* handing SLIP/PPP bytes to kernel     */
char ch);                          /*   byte input (from ISP)              */

void
do_pppfsm(void);                   /* routine PPP-to-ISP processing        */

int
slppp_up (void);                   /* bring up SLIP/PPP link to ISP        */

int
slppp_down (void);                 /* bring down SLIP/PPP link to ISP      */

void tcpkinit(void);               /* kernel initialization routine        */

#define TCPKFIN_EXISTS             /* there is a tcpkfin() routine         */
void tcpkfin(void);                /* kernel shutdown routine              */

void
pacsys1(void);                     /* Pacsoft sys cycle (BEFORE nselect()) */
                                   /*   called by PACSOFT versn of tcpsys()*/

void
pacsys2(                           /* Pacsoft sys cycle (AFTER nselect())  */
unsigned long hrtnow);             /*   clock, 1/65536 second units        */
                                   /*   called by PACSOFT versn of tcpsys()*/

void
ospflush(void);

void
ospclose(void);

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __GALHPAC_H
