/***************************************************************************
 *                                                                         *
 *   FILTCP.H                                                              *
 *                                                                         *
 *   Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   Sending & receiving files across TCP links.                           *
 *                                                                         *
 *                                        - RNStein  7/30/94               *
 *                                                                         *
 ***************************************************************************/

#ifndef __FILTCP_H
#define __FILTCP_H

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define FTCPSIZ 80                 /* size of path&file names              */

struct filtcp {                    /* file transfer session control block  */
     CHAR filpath[FTCPSIZ];        /* full path/name of file           (C) */
     INT socket;                   /* socket for transferring file     (C) */
     VOID (*callbk)(INT code);     /* call-back vector                 (C) */
     SHORT flags;                  /* see below, must init to zero     (C) */
     CHAR *buffer;                 /* poiter to buffer     (send only) (C) */
     INT bufsiz;                   /* size of buffer       (send only) (C) */
     UINT bufcnt;                  /* # bytes in buffer    (send only)     */
     ULONG maxbyt;                 /* max bytes            (recv only) (C) */
     FILE *fp;                     /* file pointer                         */
     LONG sttime;                  /* hrtval() time of last activity       */
     LONG nbytes;                  /* number of bytes transferred          */
};                                 /*     caller fills in beforehand = (C) */

                                   /*--- flag masks -----------------------*/
#define FTCFSND 0x0001             /* on=sending, off=receiving            */
#define FTCAPND 0x0002             /* append to existing file (recv only)  */

                                   /*--- call-back vector codes -----------*/
#define FTCPRG 0                   /* progress report (see nbytes)         */
#define FTCEOF 1                   /* normal completion                    */
#define FTCABT 2                   /* transfer aborted by ftcabt()         */
#define FTCOPN 3                   /* file could not be opened             */
#define FTCSER 4                   /* socket error (see tcpip_errno)       */
#define FTCBST 5                   /* size limit busted        (recv only) */
#define FTCFER 6                   /* file error (see errno)               */
#define FTCRST 7                   /* channel reset                        */

extern
INT numfsnd;                       /* cntftc() sets:  number sending       */
extern
INT numfrcv;                       /* cntftc() sets:  number receiving     */

VOID
initfiltcp(VOID);                  /* initialize filtcps stuff             */

INT
sndfiltcp(                         /* begin sending a file                 */
struct filtcp *ftcp);              /* caller fills in filpath, socket,     */
                                   /* flags, callbk, buffer, bufsiz fields */
                                   /* returns 1=trying, 0=immed failure    */

INT
rcvfiltcp(                         /* begin receiving a file               */
struct filtcp *ftcp);              /* caller fills in filpath, socket,     */
                                   /* flags, and callbk fields             */
                                   /* returns 1=trying, 0=immed failure    */

INT
cntftc(VOID);                      /* how many are receiving/transmitting? */
                                   /* also sets numfrcv, numfsnd           */

VOID
ftcabt(VOID);                      /* abort transfer (either direction)    */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif                             /* __FILTCP_H                           */
