/***************************************************************************
 *                                                                         *
 *   SMTP.H                                                                *
 *                                                                         *
 *   Copyright (c) 1995-1997 Galacticomm, Inc.  All Rights Reserved.       *
 *                                                                         *
 *   SMTP definitions and function prototypes for Worldgroup.              *
 *                                                                         *
 *                               5/28/95 - Bert Love,                      *
 *                                         Scott Brinker,                  *
 *                                         Charles Dunn &                  *
 *                                         Mahesh Neelakanta               *
 *                                                                         *
 ***************************************************************************/

#ifndef __SMTP_H
#define __SMTP_H

#include "smtpexp.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define SMTPORT     25             /* TCP port for SMTP                    */
#define SMTNAME     "SMTP"         /* name of SMTP server                  */
#define POSTID      "POSTMASTER"   /* "postmaster" mail ID                 */
#define ROOTID      "ROOT"         /* "root" mail ID                       */
#define NOHOST "HOST.NOT.SPECIFIED" /* string to cat when domain is blank  */
#define NOUSER "USER.NOT.SPECIFIED" /* string to prepend when usr is blank */
#define SMTBACKLOG  5              /* listen() backlog                     */
#define NUMLINS     50             /* maximum lines to read per cycle      */
#define DATESZ      81             /* maximum length of date               */
#define LINSIZ      80             /* UUENCODE line length                 */
#define SMTLSZ      (512+1)        /* SMTP maximum command/reply line size */
#define SMTTSZ      (1000+1)       /* SMTP maximum text line size          */
#define QNMSIZ  8                  /* maximum size of info name header     */
#define KICKINT 5                  /* rtkick interval                      */
#define SNDBSIZ 2048               /* TCP/IP send buffer size              */
#define RCVBSIZ 1024               /* TCP/IP receive buffer size           */
#define SBUFSIZ 4096               /* maximum file storage buf size        */
#define IBUFSZ  5400               /* maximum size of MIME input buffer    */
#define OBUFSZ  7300               /* maximum size of MIME output buffer   */
#define OBOSET (IBUFSZ+1)          /* MIME output buffer offset in vdatmp  */

struct rinfo {                     /* recipient information structure      */
     SHORT flags;                  /*   per-message flags (see below)      */
     CHAR to[MAXADR];              /*   To: address                        */
};
                                   /* flag defintions for rinfo            */
#define LOCRCPT 0x0001             /*   message is addressed locally       */
#define MSGSNT  0x0002             /*   message has been sent successfully */

struct minfo {                     /* message information structure        */
     CHAR name[QNMSIZ];            /*   SMTP message sanity check          */
     CHAR from[MAXADR];            /*   From: address                      */
     CHAR attfil[GCMAXPTH];        /*   file attachment specification      */
     CHAR relnam[GCMAXFNM];        /*   user-specified attachment name     */
     CHAR mimid[MIMIDSZ];          /*   maximum length of MIME boundary    */
     time_t qtime;                 /*   time msg was queued for SMTP       */
     time_t lsttim;                /*   time of last try                   */
     SHORT flags;                  /*   per-message flags (see below)      */
     INT locrcpt;                  /*   number of local recipients         */
     INT rmtrcpt;                  /*   number of remote recipients        */
     LONG hdrpos;                  /*   file position of message header    */
     LONG bdypos;                  /*   file position of message body      */
     LONG endpos;                  /*   file position of the end of msg txt*/
};
                                   /* flag definitions for minfo           */
#define LOCSNDR 0x0001             /*   message is addressed locally       */
#define HASATT  0x0002             /*   message has file attachment        */

/* if incoming Internet message is autoforwarded into another Internet     */
/* address 'inetinfo' points to the original Internet message file         */
/* this way forwarded messages will get full Internet header               */
/* IMPORTANT ! current implementation depends on how 'impmsg()' works      */
/* and can be broken by future changes                                     */

extern
struct inetinfo {                  /* Internet message pointer             */
     FILE *fp;                     /*   message file pointer               */
     LONG hdrpos;                  /*   file position of message header    */
     LONG bdypos;                  /*   file position of message body      */
} *inetinfo;                       /* Internet message pointer             */

extern HMCVFILE smtmb;             /* file handle to GALSMTP.MCV           */
extern CHAR smtobd[GCMAXPTH];      /* SMTP outbound work directory         */

                                   /* log function codes                   */
#define INCMING   0                /*   incoming data                      */
#define OUTGING   1                /*   outgoing data                      */
#define SHOWLOG   2                /*   log entry via sholog()             */

extern GBOOL smtlog;               /* is send log currently active?        */
extern CHAR *smtlnam;              /* send log file name                   */
extern CHAR *smtdpuid;             /* SMTP "postmaster" and "root" ID      */
extern CHAR *iprLocalFile;         /* file w/list of local IP ranges       */
extern CHAR *iprBlockFile;         /* file w/list of blocked IP ranges     */

#define MAXALS    16               /*   maximum number of system aliases   */
extern INT numofals;               /*   number of system aliases           */
extern CHAR mailals[MAXALS][MAXADR]; /* mail aliases                       */
extern CHAR maildaem[];            /* "From:" line for bounced e-mail      */

VOID ini_smtrcv(VOID);
VOID initAddrXlat(VOID);
INT smtsnd(const CHAR *to,const struct message *msg,const CHAR *text,
           const CHAR *filatt);
GBOOL mimdcode(FILE *inf,FILE *outf);
VOID logsmt(INT taskno,CHAR *logstr,INT type);
VOID sholog(INT taskno,CHAR *header,CHAR *footer,...);
VOID addlf(CHAR *textbuf);
CHAR *stpbkt(CHAR *string);

GBOOL
isLocalIP(                         /* is this a local IP address           */
struct in_addr inaddr);            /*   IP address to evaluate             */

GBOOL
isBlockedIP(                       /* is this a blocked IP address         */
struct in_addr inaddr);            /*   IP address to evaluate             */

INT                                /*   < 0 if stamp1 < stamp2, etc.       */
compStamp(                         /* compare time/date stamps             */
struct timestamp stamp1,           /*   first time/date stamp              */
struct timestamp stamp2);          /*   second time/date stamp             */

CHAR *
stpcr(                             /* strips CR from CR/LF                 */
CHAR *textbuf);

GBOOL                              /*   returns TRUE to halt processing    */
hookHandleExp(                     /* handle exported message              */
INT * pRet,                        /*   GME status code                    */
struct message * pMsg,             /*   header of message to send off      */
CHAR const ** pTo,                 /*   to field                           */
CHAR const ** pAtt,                /*   path+file name of attachment       */
CHAR ** pText,                     /*   message text buffer                */
size_t TextBufSize);               /*   current text buffer size           */

#ifdef __cplusplus
}; // extern "C"
#endif // __cplusplus

#endif // __SMTP_H
