/***************************************************************************
 *                                                                         *
 *   TVBUTIL.H                                                             *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module text variable-related utilities.        *
 *                                                                         *
 *                                            - J. Alvrus   02/03/1999     *
 *                                                                         *
 ***************************************************************************/

#if !defined(__TVBUTIL_H)
#define __TVBUTIL_H

#include "gcomm.h"
#include "tvb.h"

class tvbBase : public tvbDefinition { // generic text variable handler
public:
     tvbBase(                      // constructor for dynamic variables
     const CHAR *nam);             //   variable name

     tvbBase(                      // constructor for static variables
     const CHAR *nam,              //   variable name
     const CHAR *value);           //   pointer to buffer containing value

     virtual VOID
     set(                          // set value to display
     const CHAR *newValue);        //   to this string

     virtual const CHAR *
     get() const;                  // get current value

     virtual VOID
     clr();                        // clear current value

     virtual const CHAR *          //   returns text var value
     resolve(                      // resolve a text var name into its value
     const CHAR *nam);             //   name of text var being resolved

protected:                         // protected member variables
     const CHAR *m_pVal;           //   pointer to text to return
};

class tvbInt : public tvbBase {    // txt var for integer quantities
public:
     tvbInt(                       // constructor for dynamic variables
     const CHAR *name);            //   variable name

     VOID
     set(                          // set value to display
     LONG newValue);               //   to this

     VOID
     set(                          // set value to display
     ULONG newValue);              //   to this

     VOID
     set(                          // set value to display
     INT newValue);                //   to this

     VOID
     set(                          // set value to display
     UINT newValue);               //   to this

     VOID
     set(                          // set value to display
     SHORT newValue);              //   to this

     VOID
     set(                          // set value to display
     USHORT newValue);             //   to this

private:                           // private member functions

     VOID
     set(                          // this version is not used
     const CHAR *newValue)
     {}

private:                           // private data members
     CHAR m_numBuf[sizeof("-1234567890")]; // buffer for number
};

class tvbDate : public tvbBase {   // txt var for integer quantities
public:
     tvbDate(                      // constructor for dynamic variables
     const CHAR *name);            //   variable name

     VOID
     set(                          // set value to display
     USHORT dosDate);              //   DOS date format

private:                           // private member functions

     VOID
     set(                          // this version is not used
     const CHAR *newValue)
     {}

private:                           // private data members
     CHAR m_dateBuf[sizeof("12/31/1999")]; // buffer for date string
};

class tvbTime : public tvbBase {   // txt var for integer quantities
public:
     tvbTime(                      // constructor for dynamic variables
     const CHAR *name);            //   variable name

     VOID
     set(                          // set value to display
     USHORT dosTime);              //   DOS time format

private:                           // private member functions

     VOID
     set(                          // this version is not used
     const CHAR *newValue)
     {}

private:                           // private data members
     CHAR m_timeBuf[sizeof("12:00:00")]; // buffer for time string
};

class tvbEncoded : public tvbBase { // txt var requiring encoding
public:
     tvbEncoded(                   // constructor for dynamic variables
     const CHAR *name);            //   variable name

     tvbEncoded(                   // constructor for static variables
     const CHAR *name,             //   variable name
     const CHAR *value);           //   pointer to buffer containing value

     ~tvbEncoded();                // destructor

     VOID
     set(                          // set value to display
     const CHAR *newValue)=0;      //   to this string

     VOID
     clr();                        // clear current value
};

class tvbURL : public tvbEncoded { // txt var for URL components
public:
     tvbURL(                       // constructor for dynamic variables
     const CHAR *name);            //   variable name

     tvbURL(                       // constructor for static variables
     const CHAR *name,             //   variable name
     const CHAR *value);           //   pointer to buffer containing value

     VOID
     set(                          // set value to display
     const CHAR *newValue);        //   to this string
};

class tvbHTML : public tvbEncoded { // txt var for HTML components
public:
     tvbHTML(                      // constructor for dynamic variables
     const CHAR *name);            //   variable name

     tvbHTML(                      // constructor for static variables
     const CHAR *name,             //   variable name
     const CHAR *value);           //   pointer to buffer containing value

     VOID
     set(                          // set value to display
     const CHAR *newValue);        //   to this string
};

class tvbMCV : public tvbEncoded { // txt var from MCV file options
public:
     tvbMCV(                       // constructor for dynamic variables
     CHAR const * name);           //   variable name

     VOID
     set(                          // set value to display
     HMCVFILE hMcv,                //   from this file
     INT iMsg);                    //   to this option

private:                           // private member functions

     VOID
     set(                          // this version is not used
     const CHAR *newValue)
     {}
};

class tvbCheck : public tvbBase {  // txt var for "CHECKED" items in forms
public:
     tvbCheck(
     const CHAR *name);

     VOID
     setChecked(                   // set checked status
     bool isChecked);              //   is the option checked?
};

class tvbSelect : public tvbBase { // txt var for "SELECTED" items in forms
public:
     tvbSelect(
     const CHAR *name);

     VOID
     setSelected(                  // set checked status
     bool isSelected);             //   is the option checked?
};

#endif // !defined(__TVBUTIL_H)
