/***************************************************************************
 *                                                                         *
 *   TVBUTIL.CPP                                                           *
 *                                                                         *
 *   Copyright (c) 1997 Galacticomm, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   Active HTML Log On/Off Module text variable-related utilities.        *
 *                                                                         *
 *                                            - J. Alvrus   02/03/1999     *
 *                                                                         *
 ***************************************************************************/

#include "encutil.h"
#include "tvbutil.h"

#define FILREV "$Revision: 1 $"

tvbBase::tvbBase(                  // constructor for dynamic variables
const CHAR *nam) :                 //   variable name
     tvbDefinition(nam),
     m_pVal(NULL)
{
     registerDef();
}

tvbBase::tvbBase(                  // constructor for static variables
const CHAR *nam,                   //   variable name
const CHAR *value) :               //   pointer to buffer containing value
     tvbDefinition(nam)            //   (contents must be persistent)
{
     set(value);
     registerDef();
}

VOID
tvbBase::set(                      // set value to display
const CHAR *newValue)              //   to this string
{
     m_pVal=newValue;
}

const CHAR *
tvbBase::get() const               // get current value
{
     return(m_pVal);
}

VOID
tvbBase::clr()                     // clear current value
{
     m_pVal=NULL;
}

const CHAR *                       //   returns text var value
tvbBase::resolve(                  // resolve a text var name into its value
const CHAR *nam)                   //   name of text var being resolved
{
     (VOID)nam;
     if (m_pVal == NULL) {
          return("");
     }
     return(m_pVal);
}

tvbInt::tvbInt(                    // constructor for dynamic variables
const CHAR *nam) :                 //   variable name
     tvbBase(nam)
{
}

VOID
tvbInt::set(                       // set value to display
LONG newValue)                     //   to this
{
     sprintf(m_numBuf,"%ld",newValue);
     m_pVal=m_numBuf;
}

VOID
tvbInt::set(                       // set value to display
ULONG newValue)                    //   to this
{
     sprintf(m_numBuf,"%lu",newValue);
     m_pVal=m_numBuf;
}

VOID
tvbInt::set(                       // set value to display
INT newValue)                      //   to this
{
     sprintf(m_numBuf,"%d",newValue);
     m_pVal=m_numBuf;
}

VOID
tvbInt::set(                       // set value to display
UINT newValue)                     //   to this
{
     sprintf(m_numBuf,"%u",newValue);
     m_pVal=m_numBuf;
}

VOID
tvbInt::set(                       // set value to display
SHORT newValue)                    //   to this
{
     sprintf(m_numBuf,"%hd",newValue);
     m_pVal=m_numBuf;
}

VOID
tvbInt::set(                       // set value to display
USHORT newValue)                   //   to this
{
     sprintf(m_numBuf,"%hu",newValue);
     m_pVal=m_numBuf;
}

tvbDate::tvbDate(                  // constructor for dynamic variables
const CHAR *nam) :                 //   variable name
     tvbBase(nam)
{
}

VOID
tvbDate::set(                      // set value to display
USHORT dosDate)                    //   DOS date format
{
     sprintf(m_dateBuf,"%02.2d/%02.2d/%04.4d",
             ddmon(dosDate),ddday(dosDate),ddyear(dosDate));
     m_pVal=m_dateBuf;
}

tvbTime::tvbTime(                  // constructor for dynamic variables
const CHAR *nam) :                 //   variable name
     tvbBase(nam)
{
}

VOID
tvbTime::set(                      // set value to display
USHORT dosTime)                    //   DOS time format
{
     sprintf(m_timeBuf,"%02.2d:%02.2d:%02.2d",
             dthour(dosTime),dtmin(dosTime),dtsec(dosTime));
     m_pVal=m_timeBuf;
}

tvbEncoded::tvbEncoded(            // constructor for dynamic variables
const CHAR *nam) :                 //   variable name
     tvbBase(nam)
{}

tvbEncoded::tvbEncoded(            // constructor for static variables
const CHAR *nam,                   //   variable name
const CHAR *value) :               //   pointer to buffer containing value
     tvbBase(nam,value)            //   (contents must be persistent)
{}

tvbEncoded::~tvbEncoded()          // destructor
{
     clr();
}

VOID
tvbEncoded::clr()                  // clear current value
{
     if (m_pVal != NULL) {
          delete[] m_pVal;
          m_pVal=NULL;
     }
}

tvbURL::tvbURL(                    // constructor for dynamic variables
const CHAR *nam) :                 //   variable name
     tvbEncoded(nam)
{}

tvbURL::tvbURL(                    // constructor for static variables
const CHAR *nam,                   //   variable name
const CHAR *value) :               //   pointer to buffer containing value
     tvbEncoded(nam,value)         //   (contents must be persistent)
{}

VOID
tvbURL::set(                       // set value to display
const CHAR *newValue)              //   to this string
{
     clr();
     m_pVal=urlEncodeStr(newValue);
}

tvbHTML::tvbHTML(                  // constructor for dynamic variables
const CHAR *nam) :                 //   variable name
     tvbEncoded(nam)
{}

tvbHTML::tvbHTML(                  // constructor for static variables
const CHAR *nam,                   //   variable name
const CHAR *value) :               //   pointer to buffer containing value
     tvbEncoded(nam,value)         //   (contents must be persistent)
{}

VOID
tvbHTML::set(                      // set value to display
const CHAR *newValue)              //   to this string
{
     clr();
     m_pVal=entEncodeStr(newValue);
}

tvbMCV::tvbMCV(                    // constructor for dynamic variables
CHAR const * nam) :                //   variable name
     tvbEncoded(nam)
{}

VOID
tvbMCV::set(                       // set value to display
HMCVFILE hMcv,                     //   from this file
INT iMsg)                          //   to this option
{
     clr();
     setmbk(hMcv);
     CHAR const * OptStr=stpans(getasc(iMsg));
     rstmbk();
     CHAR * cp=new CHAR[strlen(OptStr)+1];
     m_pVal=strcpy(cp,OptStr);
}

tvbCheck::tvbCheck(
const CHAR *nam) :
     tvbBase(nam)
{}

VOID
tvbCheck::setChecked(              // set checked status
bool isChecked)                    //   is the option checked?
{
     if (isChecked) {
          set("CHECKED");
     }
     else {
          clr();
     }
}

tvbSelect::tvbSelect(
const CHAR *nam) :
     tvbBase(nam)
{}

VOID
tvbSelect::setSelected(            // set checked status
bool isSelected)                   //   is the option checked?
{
     if (isSelected) {
          set("SELECTED");
     }
     else {
          clr();
     }
}
